﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_2;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/位置に加算タブ/位置に加算グループデータです。
    /// </summary>
    [Serializable]
    public class AddLocationParamData : DataModelBase
    {
        /// <summary>
        /// 加算値を取得または設定します。
        /// </summary>
        private Vector3f addition = null;

        /// <summary>
        /// 加算値のパーティクル時間アニメを取得または設定します。
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public AddLocationParamData() :
            base()
        {
            this.AddGlobal = false;
            this.Addition = new Vector3f(0.0f, 0.0f, 0.0f);
            this.EnableAnimation = 0;
            this.AnimationTable = new AnimationTableData(new AnimationTableData(0, 0.0f, 0.0f, 0.0f, 0.0f));
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// ワールド座標系で適用のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7d76d9a8-4678-45db-9ff2-93ef369d0d8d")]
        public bool AddGlobal { get; set; }

        /// <summary>
        /// 加算値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("ffcb33b5-660b-4e6d-b74c-d03801097de3")]
        public Vector3f Addition
        {
            get { return this.GetObjectFromField(ref this.addition, false); }
            set { this.SetISettableToField(ref this.addition, value); }
        }

        /// <summary>
        /// 加算値のパーティクル時間アニメのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("036d10aa-8d95-416b-8a48-492990e7e6de")]
        public int EnableAnimation { get; set; }

        /// <summary>
        /// 加算値のパーティクル時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7b091aff-4c7f-4820-9a27-b31f5274875e")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// 加算値のパーティクル時間アニメについて再生方法を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("6cc3a5b5-c68f-4771-95fa-39e69438e128")]
        public int LoopMode { get; set; }

        /// <summary>
        /// 加算値のパーティクル時間アニメについて終端フレームを取得または設定します。
        /// 再生方法をループ再生にしたとき使用します。
        /// </summary>
        [DataModelPropertyGuid("8e8b9076-d30b-4e4d-a410-dba9d884b928")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// 加算値のエミッタ時間アニメについて開始位置のランダムのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e8cebe60-47a0-4ff2-afe8-0f4a20125f9a")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.AddLocationParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.AddGlobal = srcDataModel.AddGlobal;
            this.Addition = srcDataModel.Addition;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "AddGlobal", this.AddGlobal);
            this.WriteElement(context, "Addition", this.Addition);
            this.WriteElement(context, "EnableAnimation", this.EnableAnimation);
            this.WriteElement(context, "AnimationTable", this.AnimationTable);
            this.WriteElement(context, "LoopMode", this.LoopMode);
            this.WriteElement(context, "LoopEnd", this.LoopEnd);
            this.WriteElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.AddGlobal = this.ReadElement(context, "AddGlobal", this.AddGlobal);
            this.Addition = this.ReadElement(context, "Addition", this.Addition);
            this.EnableAnimation = this.ReadElement(context, "EnableAnimation", this.EnableAnimation);
            this.AnimationTable = this.ReadElement(context, "AnimationTable", this.AnimationTable);
            this.LoopMode = this.ReadElement(context, "LoopMode", this.LoopMode);
            this.LoopEnd = this.ReadElement(context, "LoopEnd", this.LoopEnd);
            this.Randomize = this.ReadElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.AddLocationParamData(PrevVersion.AddLocationParamData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.AddLocationParamData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.AddLocationParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.AddGlobal = srcDataModel.AddGlobal;
            this.Addition = srcDataModel.Addition;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }
    }
}
