﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_2;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/基本設定タブデータです。
    /// </summary>
    [Serializable]
    public class EmitterSetBasicData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterSetBasicData() :
            base()
        {
            this.Comment = string.Empty;
            this.LabelColor = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// エミッタセットの名前を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("48dd1a0f-88b8-4767-a4e0-33e87e586c5b")]
        public string Name
        {
            get
            {
                var eset = this.Parent as EmitterSetData;
                if (eset == null)
                {
                    return string.Empty;
                }

                return eset.Name;
            }
        }

        /// <summary>
        /// エミッタセットのファイルパスを取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("e441551b-0f7f-4722-8b9e-ba7327093c0c")]
        public string FilePath
        {
            get
            {
                var eset = this.Parent as EmitterSetData;
                if (eset == null)
                {
                    return string.Empty;
                }

                return eset.FilePath;
            }
        }

        /// <summary>
        /// コメントを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d8892ebe-e7db-485b-bc48-ea27d841209d")]
        public string Comment { get; set; }

        /// <summary>
        /// EffectBrowserで表示するラベルカラー番号を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("848b7b0e-b3dc-4b18-8afe-6f96dced96ad")]
        public int LabelColor { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterSetBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Comment = srcDataModel.Comment;
            this.LabelColor = srcDataModel.LabelColor;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Comment", this.Comment);
            this.WriteElement(context, "LabelColor", this.LabelColor);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Comment = this.ReadElement(context, "Comment", this.Comment);
            this.LabelColor = this.ReadElement(context, "LabelColor", this.LabelColor);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterSetBasicData(PrevVersion.EmitterSetBasicData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterSetBasicData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterSetBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Comment = srcDataModel.Comment;
            this.LabelColor = srcDataModel.LabelColor;

            return true;
        }
    }
}
