﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/ランダムデータです。
    /// </summary>
    [Serializable]
    public class RandomParamData : DataModelBase
    {
        /// <summary>
        /// ランダム幅.
        /// </summary>
        private Vector3f velAdd = null;

        /// <summary>
        /// アニメーションテーブルです。
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public RandomParamData() :
            base()
        {
            this.BlankFrames = 1000;
            this.VelAdd = new Vector3f(0.0f, 0.0f, 0.0f);
            this.EnableAnimation = 0;
            this.AnimationTable = new AnimationTableData(new AnimationTableData(0, 0.0f, 0.0f, 0.0f, 0.0f));
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;
            this.EnableFixedSeed = false;
            this.EnableDetailedOption = false;
            this.IsInitPhaseRandom = false;
            this.WaveParam0 = 4.0f;
            this.WaveParam1 = 3.0f;
            this.WaveParam2 = 2.0f;
            this.WaveParam3 = 1.5f;
            this.WaveParamHzRate0 = 0.6f;
            this.WaveParamHzRate1 = 0.42f;
            this.WaveParamHzRate2 = 0.23f;
            this.WaveParamHzRate3 = 0.15f;
            this.WaveParamRandom0 = 0;
            this.WaveParamRandom1 = 0;
            this.WaveParamRandom2 = 0;
            this.WaveParamRandom3 = 0;
            this.RandomSeedX = 0;
            this.RandomSeedY = 0;
            this.RandomSeedZ = 0;
            this.RandomSeedW = 0;
            this.EnableCombineFluctuation = false;
            this.FlucAmplitude = 1;
            this.FlucCycle = 20;
            this.FlucInitPhase = 0;
            this.IsFlucInitPhaseRandom = false;
            this.EasyCombineParam = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// ランダム適用間隔(フレーム)です.
        /// </summary>
        [DataModelPropertyGuid("806b2a8b-6871-4bd6-85fc-a726dc782b8b")]
        public int BlankFrames { get; set; }

        /// <summary>
        /// ランダム幅.
        /// </summary>
        [DataModelPropertyGuid("d4556995-ebb8-44fb-93b8-106461a79e57")]
        public Vector3f VelAdd
        {
            get { return this.GetObjectFromField(ref this.velAdd, false); }
            set { this.SetISettableToField(ref this.velAdd, value); }
        }

        /// <summary>
        /// アニメーションの有無を表すフラグです。
        /// </summary>
        [DataModelPropertyGuid("f4efe157-bbf3-491a-be16-175a53e01937")]
        public int EnableAnimation { get; set; }

        /// <summary>
        /// アニメーションテーブルです。
        /// </summary>
        [DataModelPropertyGuid("40e1cfe2-2f68-48c0-9e90-3f8de7f440e7")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// アニメーションの再生タイプです。
        /// </summary>
        [DataModelPropertyGuid("83b75742-89be-4523-b414-97018e765ad3")]
        public int LoopMode { get; set; }

        /// <summary>
        /// ループ再生にした際の終端フレームです。
        /// </summary>
        [DataModelPropertyGuid("6f91cd9e-2658-4a2d-8cf1-ba3939a37971")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// 開始位置をランダム化するか否かのフラグです。
        /// </summary>
        [DataModelPropertyGuid("5ae48c7b-621b-4fc2-a63a-eab6895d883d")]
        public int Randomize { get; set; }

        /// <summary>
        /// 乱数の種を固定するかどうかのフラグです
        /// </summary>
        [DataModelPropertyGuid("91be1123-50ff-4c27-a041-b3c343088da5")]
        public bool EnableFixedSeed { get; set; }

        /// <summary>
        /// 詳細設定を有効にするかどうかのフラグです
        /// </summary>
        [DataModelPropertyGuid("4cc71270-ee54-44f7-ba53-7f0347c92952")]
        public bool EnableDetailedOption { get; set; }

        /// <summary>
        /// 初期位相をランダムにするかどうかのフラグです。
        /// </summary>
        [DataModelPropertyGuid("d6b700ea-e5c9-46a5-813f-f38b38d9c660")]
        public bool IsInitPhaseRandom { get; set; }

        /// <summary>
        /// 波形0の重み係数
        /// </summary>
        [DataModelPropertyGuid("0b613c39-6a82-44f3-946e-ac56403b0bea")]
        public float WaveParam0 { get; set; }

        /// <summary>
        /// 波形1の重み係数
        /// </summary>
        [DataModelPropertyGuid("93cfbdc5-fb91-42d5-b2db-2259215c0ba4")]
        public float WaveParam1 { get; set; }

        /// <summary>
        /// 波形2の重み係数
        /// </summary>
        [DataModelPropertyGuid("2b77e1d0-6b01-4f5d-8fcc-28368cca3149")]
        public float WaveParam2 { get; set; }

        /// <summary>
        /// 波形3の重み係数
        /// </summary>
        [DataModelPropertyGuid("07ace006-f796-42fc-82f7-6b3ca8c0e17b")]
        public float WaveParam3 { get; set; }

        /// <summary>
        /// 成分0の周波数の、基本周波数に対する比率
        /// </summary>
        [DataModelPropertyGuid("40b58f10-b890-4ec6-9668-8182b9c8b5ec")]
        public float WaveParamHzRate0 { get; set; }

        /// <summary>
        /// 成分1の周波数の、基本周波数に対する比率
        /// </summary>
        [DataModelPropertyGuid("7a66c3e9-d4b3-4b98-8c83-ce13bea991d3")]
        public float WaveParamHzRate1 { get; set; }

        /// <summary>
        /// 成分2の周波数の、基本周波数に対する比率
        /// </summary>
        [DataModelPropertyGuid("59d938f4-b7fd-48ac-8b6a-1f3a972dd4ed")]
        public float WaveParamHzRate2 { get; set; }

        /// <summary>
        /// 成分3の周波数の、基本周波数に対する比率
        /// </summary>
        [DataModelPropertyGuid("2b8fd0fa-703c-4ad1-bf0c-e7a306c1651a")]
        public float WaveParamHzRate3 { get; set; }

        /// <summary>
        /// 成分0のランダム幅
        /// </summary>
        [DataModelPropertyGuid("4b6f9e49-ceeb-42f1-a774-08fae900056f")]
        public float WaveParamRandom0 { get; set; }

        /// <summary>
        /// 成分1のランダム幅
        /// </summary>
        [DataModelPropertyGuid("cdeaf58f-c8c7-4b96-8d4f-989f35c666be")]
        public float WaveParamRandom1 { get; set; }

        /// <summary>
        /// 成分2のランダム幅
        /// </summary>
        [DataModelPropertyGuid("13371b4c-5f8f-439c-9558-f806152a589d")]
        public float WaveParamRandom2 { get; set; }

        /// <summary>
        /// 成分3のランダム幅
        /// </summary>
        [DataModelPropertyGuid("3cfb50ec-900a-4bc8-bcfd-3fdcd34694ae")]
        public float WaveParamRandom3 { get; set; }

        /// <summary>
        /// 固定乱数の種
        /// </summary>
        [DataModelPropertyGuid("a587d61e-4c3e-42a1-9dc3-ad7803b2da09")]
        public float RandomSeedX { get; set; }

        /// <summary>
        /// 固定乱数の種
        /// </summary>
        [DataModelPropertyGuid("fcdc9037-4489-44bc-a921-f3e5f205cfb8")]
        public float RandomSeedY { get; set; }

        /// <summary>
        /// 固定乱数の種
        /// </summary>
        [DataModelPropertyGuid("223196c0-8d00-4df6-81d3-11eb094b6779")]
        public float RandomSeedZ { get; set; }

        /// <summary>
        /// 固定乱数の種
        /// </summary>
        [DataModelPropertyGuid("49f1ecea-d453-41ee-91bd-fc38a9733e2f")]
        public float RandomSeedW { get; set; }

        /// <summary>
        /// 重み揺らぎフラグ
        /// </summary>
        [DataModelPropertyGuid("b3128c86-1b62-489d-b01b-da83107e91d5")]
        public bool EnableCombineFluctuation { get; set; }

        /// <summary>
        /// 重み揺らぎ振幅
        /// </summary>
        [DataModelPropertyGuid("2b6cb59f-dba3-4a49-b1c4-de427231f70c")]
        public float FlucAmplitude { get; set; }

        /// <summary>
        /// 重み揺らぎ周期
        /// </summary>
        [DataModelPropertyGuid("7c427270-5ba4-4bf3-94e0-d17232eebbb9")]
        public int FlucCycle { get; set; }

        /// <summary>
        /// 重み揺らぎ初期位相
        /// </summary>
        [DataModelPropertyGuid("f7646430-6c4a-4154-a82b-317c36dd1b16")]
        public int FlucInitPhase { get; set; }

        /// <summary>
        /// 重み揺らぎ初期位相ランダム
        /// </summary>
        [DataModelPropertyGuid("08efb833-67b2-4d56-94a5-0f3426f68aa6")]
        public bool IsFlucInitPhaseRandom { get; set; }

        /// <summary>
        /// 簡易パラメータ調整用変数
        /// </summary>
        [DataModelPropertyGuid("2637d2c0-d76d-49b9-bb2d-c13df14119b3")]
        public float EasyCombineParam { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.RandomParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.BlankFrames = srcDataModel.BlankFrames;
            this.VelAdd = srcDataModel.VelAdd;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;
            this.EnableFixedSeed = srcDataModel.EnableFixedSeed;
            this.EnableDetailedOption = srcDataModel.EnableDetailedOption;
            this.IsInitPhaseRandom = srcDataModel.IsInitPhaseRandom;
            this.WaveParam0 = srcDataModel.WaveParam0;
            this.WaveParam1 = srcDataModel.WaveParam1;
            this.WaveParam2 = srcDataModel.WaveParam2;
            this.WaveParam3 = srcDataModel.WaveParam3;
            this.WaveParamHzRate0 = srcDataModel.WaveParamHzRate0;
            this.WaveParamHzRate1 = srcDataModel.WaveParamHzRate1;
            this.WaveParamHzRate2 = srcDataModel.WaveParamHzRate2;
            this.WaveParamHzRate3 = srcDataModel.WaveParamHzRate3;
            this.WaveParamRandom0 = srcDataModel.WaveParamRandom0;
            this.WaveParamRandom1 = srcDataModel.WaveParamRandom1;
            this.WaveParamRandom2 = srcDataModel.WaveParamRandom2;
            this.WaveParamRandom3 = srcDataModel.WaveParamRandom3;
            this.RandomSeedX = srcDataModel.RandomSeedX;
            this.RandomSeedY = srcDataModel.RandomSeedY;
            this.RandomSeedZ = srcDataModel.RandomSeedZ;
            this.RandomSeedW = srcDataModel.RandomSeedW;
            this.EnableCombineFluctuation = srcDataModel.EnableCombineFluctuation;
            this.FlucAmplitude = srcDataModel.FlucAmplitude;
            this.FlucCycle = srcDataModel.FlucCycle;
            this.FlucInitPhase = srcDataModel.FlucInitPhase;
            this.IsFlucInitPhaseRandom = srcDataModel.IsFlucInitPhaseRandom;
            this.EasyCombineParam = srcDataModel.EasyCombineParam;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "BlankFrames", this.BlankFrames);
            this.WriteElement(context, "VelAdd", this.VelAdd);
            this.WriteElement(context, "EnableAnimation", this.EnableAnimation);
            this.WriteElement(context, "AnimationTable", this.AnimationTable);
            this.WriteElement(context, "LoopMode", this.LoopMode);
            this.WriteElement(context, "LoopEnd", this.LoopEnd);
            this.WriteElement(context, "Randomize", this.Randomize);
            this.WriteElement(context, "EnableFixedSeed", this.EnableFixedSeed);
            this.WriteElement(context, "EnableDetailedOption", this.EnableDetailedOption);
            this.WriteElement(context, "IsInitPhaseRandom", this.IsInitPhaseRandom);
            this.WriteElement(context, "WaveParam0", this.WaveParam0);
            this.WriteElement(context, "WaveParam1", this.WaveParam1);
            this.WriteElement(context, "WaveParam2", this.WaveParam2);
            this.WriteElement(context, "WaveParam3", this.WaveParam3);
            this.WriteElement(context, "WaveParamHzRate0", this.WaveParamHzRate0);
            this.WriteElement(context, "WaveParamHzRate1", this.WaveParamHzRate1);
            this.WriteElement(context, "WaveParamHzRate2", this.WaveParamHzRate2);
            this.WriteElement(context, "WaveParamHzRate3", this.WaveParamHzRate3);
            this.WriteElement(context, "WaveParamRandom0", this.WaveParamRandom0);
            this.WriteElement(context, "WaveParamRandom1", this.WaveParamRandom1);
            this.WriteElement(context, "WaveParamRandom2", this.WaveParamRandom2);
            this.WriteElement(context, "WaveParamRandom3", this.WaveParamRandom3);
            this.WriteElement(context, "RandomSeedX", this.RandomSeedX);
            this.WriteElement(context, "RandomSeedY", this.RandomSeedY);
            this.WriteElement(context, "RandomSeedZ", this.RandomSeedZ);
            this.WriteElement(context, "RandomSeedW", this.RandomSeedW);
            this.WriteElement(context, "EnableCombineFluctuation", this.EnableCombineFluctuation);
            this.WriteElement(context, "FlucAmplitude", this.FlucAmplitude);
            this.WriteElement(context, "FlucCycle", this.FlucCycle);
            this.WriteElement(context, "FlucInitPhase", this.FlucInitPhase);
            this.WriteElement(context, "IsFlucInitPhaseRandom", this.IsFlucInitPhaseRandom);
            this.WriteElement(context, "EasyCombineParam", this.EasyCombineParam);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.BlankFrames = this.ReadElement(context, "BlankFrames", this.BlankFrames);
            this.VelAdd = this.ReadElement(context, "VelAdd", this.VelAdd);
            this.EnableAnimation = this.ReadElement(context, "EnableAnimation", this.EnableAnimation);
            this.AnimationTable = this.ReadElement(context, "AnimationTable", this.AnimationTable);
            this.LoopMode = this.ReadElement(context, "LoopMode", this.LoopMode);
            this.LoopEnd = this.ReadElement(context, "LoopEnd", this.LoopEnd);
            this.Randomize = this.ReadElement(context, "Randomize", this.Randomize);
            this.EnableFixedSeed = this.ReadElement(context, "EnableFixedSeed", this.EnableFixedSeed);
            this.EnableDetailedOption = this.ReadElement(context, "EnableDetailedOption", this.EnableDetailedOption);
            this.IsInitPhaseRandom = this.ReadElement(context, "IsInitPhaseRandom", this.IsInitPhaseRandom);
            this.WaveParam0 = this.ReadElement(context, "WaveParam0", this.WaveParam0);
            this.WaveParam1 = this.ReadElement(context, "WaveParam1", this.WaveParam1);
            this.WaveParam2 = this.ReadElement(context, "WaveParam2", this.WaveParam2);
            this.WaveParam3 = this.ReadElement(context, "WaveParam3", this.WaveParam3);
            this.WaveParamHzRate0 = this.ReadElement(context, "WaveParamHzRate0", this.WaveParamHzRate0);
            this.WaveParamHzRate1 = this.ReadElement(context, "WaveParamHzRate1", this.WaveParamHzRate1);
            this.WaveParamHzRate2 = this.ReadElement(context, "WaveParamHzRate2", this.WaveParamHzRate2);
            this.WaveParamHzRate3 = this.ReadElement(context, "WaveParamHzRate3", this.WaveParamHzRate3);
            this.WaveParamRandom0 = this.ReadElement(context, "WaveParamRandom0", this.WaveParamRandom0);
            this.WaveParamRandom1 = this.ReadElement(context, "WaveParamRandom1", this.WaveParamRandom1);
            this.WaveParamRandom2 = this.ReadElement(context, "WaveParamRandom2", this.WaveParamRandom2);
            this.WaveParamRandom3 = this.ReadElement(context, "WaveParamRandom3", this.WaveParamRandom3);
            this.RandomSeedX = this.ReadElement(context, "RandomSeedX", this.RandomSeedX);
            this.RandomSeedY = this.ReadElement(context, "RandomSeedY", this.RandomSeedY);
            this.RandomSeedZ = this.ReadElement(context, "RandomSeedZ", this.RandomSeedZ);
            this.RandomSeedW = this.ReadElement(context, "RandomSeedW", this.RandomSeedW);
            this.EnableCombineFluctuation = this.ReadElement(context, "EnableCombineFluctuation", this.EnableCombineFluctuation);
            this.FlucAmplitude = this.ReadElement(context, "FlucAmplitude", this.FlucAmplitude);
            this.FlucCycle = this.ReadElement(context, "FlucCycle", this.FlucCycle);
            this.FlucInitPhase = this.ReadElement(context, "FlucInitPhase", this.FlucInitPhase);
            this.IsFlucInitPhaseRandom = this.ReadElement(context, "IsFlucInitPhaseRandom", this.IsFlucInitPhaseRandom);
            this.EasyCombineParam = this.ReadElement(context, "EasyCombineParam", this.EasyCombineParam);

            return success;
        }
    }
}
