﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/パーティクルタブデータです。
    /// </summary>
    [Serializable]
    public class EmitterParticleData : DataModelBase
    {
        /// <summary>
        /// パーティクル寿命グループデータを取得または設定します。
        /// </summary>
        private EmitterParticleLifeData emitterParticleLifeData = null;

        /// <summary>
        /// 運動量ランダムグループデータです。
        /// 未使用データです。
        /// </summary>
        private EmitterParticleRandomData emitterParticleRandomData = null;

        /// <summary>
        /// パーティクル設定グループデータを取得または設定します。
        /// </summary>
        private EmitterParticleShapeData emitterParticleShapeData = null;

        /// <summary>
        /// 揺らぎ設定グループデータを取得または設定します。
        /// </summary>
        private EmitterParticleFluctuationData emitterParticleFluctutaionData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterParticleData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// パーティクル寿命グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("23786016-2bd0-49cd-9d1f-168c6a7746e3")]
        public EmitterParticleLifeData EmitterParticleLifeData
        {
            get { return this.GetDataModelFromField(ref this.emitterParticleLifeData, false); }
            set { this.SetDataModelToField(ref this.emitterParticleLifeData, value); }
        }

        /// <summary>
        /// 運動量ランダムグループデータです。
        /// 未使用データです。
        /// </summary>
        [DataModelPropertyGuid("841246d5-b994-4d22-a697-a212e5e9df81")]
        public EmitterParticleRandomData EmitterParticleRandomData
        {
            get { return this.GetDataModelFromField(ref this.emitterParticleRandomData, false); }
            set { this.SetDataModelToField(ref this.emitterParticleRandomData, value); }
        }

        /// <summary>
        /// パーティクル設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("a8921058-beb6-45c2-b843-1d5a105553c9")]
        public EmitterParticleShapeData EmitterParticleShapeData
        {
            get { return this.GetDataModelFromField(ref this.emitterParticleShapeData, false); }
            set { this.SetDataModelToField(ref this.emitterParticleShapeData, value); }
        }

        /// <summary>
        /// 揺らぎ設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5ae6d108-cac3-41b1-a159-6b7c5f46717e")]
        public EmitterParticleFluctuationData EmitterParticleFluctutaionData
        {
            get { return this.GetDataModelFromField(ref this.emitterParticleFluctutaionData, false); }
            set { this.SetDataModelToField(ref this.emitterParticleFluctutaionData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterParticleData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterParticleLifeData = srcDataModel.EmitterParticleLifeData;
            this.EmitterParticleRandomData = srcDataModel.EmitterParticleRandomData;
            this.EmitterParticleShapeData = srcDataModel.EmitterParticleShapeData;
            this.EmitterParticleFluctutaionData = srcDataModel.EmitterParticleFluctutaionData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterParticleLifeData", this.EmitterParticleLifeData);
            this.WriteElement(context, "EmitterParticleRandomData", this.EmitterParticleRandomData);
            this.WriteElement(context, "EmitterParticleShapeData", this.EmitterParticleShapeData);
            this.WriteElement(context, "EmitterParticleFluctutaionData", this.EmitterParticleFluctutaionData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterParticleLifeData = this.ReadElement(context, "EmitterParticleLifeData", this.EmitterParticleLifeData);
            this.EmitterParticleRandomData = this.ReadElement(context, "EmitterParticleRandomData", this.EmitterParticleRandomData);
            this.EmitterParticleShapeData = this.ReadElement(context, "EmitterParticleShapeData", this.EmitterParticleShapeData);
            this.EmitterParticleFluctutaionData = this.ReadElement(context, "EmitterParticleFluctutaionData", this.EmitterParticleFluctutaionData);

            return success;
        }
    }
}
