﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Manager;
using EffectMaker.Foundation.Primitives;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// Data model for an array of primitive.
    /// This data model is made for writing binary data.
    /// </summary>
    /// <remarks>
    /// This data model is not generated from the DataModelMaker, do not overwrite it.
    /// </remarks>
    public class PrimitiveArrayData : DataModelBase
    {
        /// <summary>The list of primitive resource data.</summary>
        private List<PrimitiveResourceData> primitiveResourceList = new List<PrimitiveResourceData>();

        /// <summary>The list of trimming primitive resource data.</summary>
        private List<TrimmingPrimitiveResourceData> trimmingPrimitiveResourceList = new List<TrimmingPrimitiveResourceData>();

        /// <summary>
        /// Constructor.
        /// </summary>
        public PrimitiveArrayData() :
            base()
        {
        }

        /// <summary>
        /// Get or set the list of primitive resource data.
        /// </summary>
        public IEnumerable<PrimitiveResourceData> PrimitiveResources
        {
            get { return this.primitiveResourceList; }
        }

        /// <summary>
        /// Get or set the list of trimming primitive resource data.
        /// </summary>
        public IEnumerable<TrimmingPrimitiveResourceData> TrimmingPrimitiveResources
        {
            get { return this.trimmingPrimitiveResourceList; }
        }

        /// <summary>
        /// Add a new texture path to the primitive array, the corresponding
        /// primitive resource data and primitive binary data will be automatically
        /// created.
        /// </summary>
        /// <param name="path">The texture path.</param>
        public void AddPrimitivePath(string path)
        {
            var primitiveRes = new PrimitiveResourceData()
            {
                Parent = this,
                PrimitivePath = path
            };

            this.primitiveResourceList.Add(primitiveRes);
        }

        /// <summary>
        /// トリミングプリミティブのテクスチャパスを追加します。
        /// </summary>
        /// <param name="path">テクスチャパス</param>
        public void AddTrimmingTexturePath(string path)
        {
            var primitiveRes = new TrimmingPrimitiveResourceData()
            {
                Parent = this,
                TexturePath = path
            };

            this.trimmingPrimitiveResourceList.Add(primitiveRes);
        }

        /// <summary>
        /// Set up the data model with the given source object.
        /// </summary>
        /// <param name="src">The source object to set from.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as PrimitiveArrayData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.SetDataModelListToField(
                ref this.primitiveResourceList,
                srcDataModel.primitiveResourceList);

            this.SetDataModelListToField(
                ref this.trimmingPrimitiveResourceList,
                srcDataModel.trimmingPrimitiveResourceList);

            return true;
        }
    }
}
