﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.DataModels;

namespace EffectMaker.DataModel.Specific.DataModels
{
    public class EmitterSetFilePathTableData : DataModelBase
    {
        /// <summary>
        /// エミッタセットのファイルパスリストです。
        /// </summary>
        private List<string> emitterSetPaths = new List<string>();

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public EmitterSetFilePathTableData() : base()
        {
        }

        /// <summary>
        /// エミッタセットのファイルパスリストを取得します。
        /// </summary>
        public IEnumerable<string> EmitterSetPaths
        {
            get { return this.emitterSetPaths; }
        }

        /// <summary>
        /// エミッタセットのファイルパスを追加します。
        /// </summary>
        /// <param name="path"></param>
        public void AddEmitterSetPath(string path)
        {
            this.emitterSetPaths.Add(path);
        }

        /// <summary>
        /// Set up the data model with the given source object.
        /// </summary>
        /// <param name="src">The source object to set from.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterSetFilePathTableData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.emitterSetPaths = new List<string>(srcDataModel.emitterSetPaths);

            return true;
        }
    }
}
