﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using ComboBoxItemType = System.Collections.Generic.KeyValuePair<string, object>;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Imaging;
using System.Threading.Tasks;
using System.Windows;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Utility;
using EffectMaker.UILogic.Properties;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the PreviewAutoMoveViewModel.
    /// </summary>
    public class PreviewAutoMoveGroupViewModel : PropertyGroupViewModel<PreviewAutoMoveData>, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public PreviewAutoMoveGroupViewModel(HierarchyViewModel parent, PreviewAutoMoveData dataModel)
            : base(parent, dataModel)
        {
            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// Get the auto move type combo box items.
        /// </summary>
        public IEnumerable<ComboBoxItemType> MoveTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(DataModelLogic.ResourceAccessor.GetString("UserDataModelAutoMoveComboBoxItemNothing"), 0),
                    new ComboBoxItemType(DataModelLogic.ResourceAccessor.GetString("UserDataModelAutoMoveComboBoxItemMoveOnXZ"), 1),
                    new ComboBoxItemType(DataModelLogic.ResourceAccessor.GetString("UserDataModelAutoMoveComboBoxItemMoveStraight"), 2),
                };
            }
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
