﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.UILogic.ViewModels.Factories
{
    /// <summary>
    /// Factory class to create specific instance of the general FieldViewModel type.
    /// </summary>
    public static class FieldViewModelFactory
    {
        /// <summary>
        /// Creates a specific instance of the general FieldViewModel type,
        /// based on the FieldData type.
        /// </summary>
        /// <param name="parent">The parent view model. Note that the created
        /// view model is NOT added to it's parent's children collection.</param>
        /// <param name="dataModel">A specific field data instance.</param>
        /// <returns>Returns a specific instance of a FieldViewModel if succeeded,
        /// null otherwise.</returns>
        public static FieldViewModel CreateFieldViewModel(
            HierarchyViewModel parent,
            FieldDataBase dataModel)
        {
            var addLocationData = dataModel as AddLocationData;
            if (addLocationData != null)
            {
                return new AddLocationViewModel(parent, addLocationData);
            }

            var collisionData = dataModel as CollisionData;
            if (collisionData != null)
            {
                return new CollisionViewModel(parent, collisionData);
            }

            var convergeData = dataModel as ConvergeData;
            if (convergeData != null)
            {
                return new ConvergeViewModel(parent, convergeData);
            }

            var curlNoiseData = dataModel as CurlNoiseData;
            if (curlNoiseData != null)
            {
                return new CurlNoiseViewModel(parent, curlNoiseData);
            }

            var magnetData = dataModel as MagnetData;
            if (magnetData != null)
            {
                return new MagnetViewModel(parent, magnetData);
            }

            var randomData = dataModel as RandomData;
            if (randomData != null)
            {
                return new RandomViewModel(parent, randomData);
            }

            var randomFe1Data = dataModel as RandomFe1Data;
            if (randomFe1Data != null)
            {
                return new RandomFe1ViewModel(parent, randomFe1Data);
            }

            var spinData = dataModel as SpinData;
            if (spinData != null)
            {
                return new SpinViewModel(parent, spinData);
            }

            var customFieldData = dataModel as CustomFieldData;
            if (customFieldData != null)
            {
                return new CustomViewModel(parent, customFieldData);
            }

            return null;
        }
    }
}
