﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the EmitterData.
    /// </summary>
    public class EmitterParticleViewModel : PropertyPageViewModel<EmitterParticleData>, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterParticleViewModel(HierarchyViewModel parent, EmitterParticleData dataModel)
            : base(parent, dataModel)
        {
            this.EmitterParticleLifeViewModel = new EmitterParticleLifeViewModel(
                this, dataModel.EmitterParticleLifeData);
            this.Children.Add(this.EmitterParticleLifeViewModel);

            this.EmitterParticleRandomViewModel = new EmitterParticleRandomViewModel(
                this, dataModel.EmitterParticleRandomData);
            this.Children.Add(this.EmitterParticleRandomViewModel);

            this.EmitterParticleShapeViewModel = new EmitterParticleShapeViewModel(
                this, dataModel.EmitterParticleShapeData);
            this.Children.Add(this.EmitterParticleShapeViewModel);

            this.EmitterParticleFluctuationViewModel = new EmitterParticleFluctuationViewModel(
                this, dataModel.EmitterParticleFluctutaionData);
            this.Children.Add(this.EmitterParticleFluctuationViewModel);

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// EmitterParticleLifeViewModel.
        /// </summary>
        public EmitterParticleLifeViewModel EmitterParticleLifeViewModel { get; private set; }

        /// <summary>
        /// EmitterParticleRandomViewModel.
        /// </summary>
        public EmitterParticleRandomViewModel EmitterParticleRandomViewModel { get; private set; }

        /// <summary>
        /// EmitterParticleShapeViewModel.
        /// </summary>
        public EmitterParticleShapeViewModel EmitterParticleShapeViewModel { get; private set; }

        /// <summary>
        /// EmitterParticleFluctuationViewModel.
        /// </summary>
        public EmitterParticleFluctuationViewModel EmitterParticleFluctuationViewModel { get; private set; }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel
        {
            get;
            private set;
        }
    }
}
