﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;
using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// ループ情報
    /// </summary>
    public class EmitterEmitterColorAnimationViewModel : PropertyGroupViewModel<EmitterEmitterColorAnimationData>, IModificationFlagOwner
    {
        /// <summary>
        /// 補間方式リニア
        /// </summary>
        private const int InterpolationMethodTypeItemsLinear = 0;

        /// <summary>
        /// 補間方式スムース
        /// </summary>
        private const int InterpolationMethodTypeItemsSmooth = 1;

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterEmitterColorAnimationViewModel(
            HierarchyViewModel parent, EmitterEmitterColorAnimationData dataModel)
            : base(parent, dataModel)
        {
            this.InterpolationMethodTypeItems = new KeyValuePair<string, object>[]
            {
                new KeyValuePair<string, object>(Properties.Resources.EmitterEmitterColorInterpolationMethodTypeLinear, EmitterEmitterColorAnimationViewModel.InterpolationMethodTypeItemsLinear),
                new KeyValuePair<string, object>(Properties.Resources.EmitterEmitterColorInterpolationMethodTypeSmooth, EmitterEmitterColorAnimationViewModel.InterpolationMethodTypeItemsSmooth),
            };

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>カラー0挙動タイプの項目を取得します.</summary>
        public IEnumerable<KeyValuePair<string, object>> InterpolationMethodTypeItems
        {
            get;
            private set;
        }

        /// <summary>
        /// 親ViewModelのプロパティ変更を通知するアクションを取得または設定します。
        /// </summary>
        public Action RaiseActionEnableLoop { get; set; }

        /// <summary>
        /// ループするか
        /// </summary>
        public bool EnableLoop
        {
            get
            {
                return this.DataModel.EnableLoop;
            }

            set
            {
                var binder = new EffectMaker.Foundation.Dynamic.EffectMakerSetMemberBinder(
                    ViewModelBase.NameOf(() => this.EnableLoop), false, true);
                this.TrySetMember(binder, value);
                if (this.RaiseActionEnableLoop != null)
                {
                    this.RaiseActionEnableLoop();
                }
            }
        }

        /// <summary>
        /// 親ViewModelのプロパティ変更を通知するアクションを取得または設定します。
        /// </summary>
        public Action RaiseActionInterpolationMethod { get; set; }

        /// <summary>
        /// 補間方式です
        /// </summary>
        public int InterpolationMethod
        {
            get
            {
                return this.DataModel.InterpolationMethod;
            }

            set
            {
                var binder = new EffectMaker.Foundation.Dynamic.EffectMakerSetMemberBinder(
                    ViewModelBase.NameOf(() => this.InterpolationMethod), false, true);
                this.TrySetMember(binder, value);
                if (this.RaiseActionInterpolationMethod != null)
                {
                    this.RaiseActionInterpolationMethod();
                }
            }
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
