﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.Editting;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the EmitterData.
    /// </summary>
    public class EmitterCombinerViewModel : PropertyPageViewModel<EmitterCombinerData>, IModificationFlagOwner
    {
        /// <summary>
        /// 変更の対象に含めないプロパティ名のリストです.
        /// </summary>
        private readonly string[] ignorePropertyNames = new string[]
        {
            "EnableParticleShaderGroup"
        };

        /// <summary>
        /// パーティクルシェーダグループの表示状態.
        /// </summary>
        private bool enableParticleShaderGroup = true;

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterCombinerViewModel(HierarchyViewModel parent, EmitterCombinerData dataModel)
            : base(parent, dataModel)
        {
            this.EmitterCombinerEquationViewModel = new EmitterCombinerEquationViewModel(
                this, dataModel.EmitterCombinerEquationData);
            this.Children.Add(this.EmitterCombinerEquationViewModel);

            this.EmitterCombinerShaderViewModel = new EmitterCombinerShaderViewModel(
                this, dataModel.EmitterCombinerShaderData);
            this.Children.Add(this.EmitterCombinerShaderViewModel);

            this.EmitterCombinerEditorViewModel = new EmitterCombinerEditorViewModel(
                this, dataModel.EmitterCombinerEditorData);
            this.Children.Add(this.EmitterCombinerEditorViewModel);

            // イベントハンドラを登録
            this.EmitterCombinerShaderViewModel.PropertyChanged +=
                this.EmitterCombinerEquationViewModel.OnShaderPropertyChanged;

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
            this.ModificationFlagViewModel.AddIgnoreProperties(this.ignorePropertyNames);
        }

        /// <summary>
        /// パーティクルシェーダグループの表示状態.
        /// </summary>
        public bool EnableParticleShaderGroup
        {
            get
            {
                return this.enableParticleShaderGroup;
            }

            set
            {
                this.SetValue(ref this.enableParticleShaderGroup, value);
                this.EmitterCombinerShaderViewModel.GroupVisibility = true;
                this.EmitterCombinerShaderViewModel.GroupVisibility = value;
            }
        }

        /// <summary>
        /// EmitterCombinerEquationViewModel.
        /// </summary>
        public EmitterCombinerEquationViewModel EmitterCombinerEquationViewModel { get; private set; }

        /// <summary>
        /// EmitterCombinerShaderViewModel.
        /// </summary>
        public EmitterCombinerShaderViewModel EmitterCombinerShaderViewModel { get; private set; }

        /// <summary>
        /// EmitterCombinerEditorViewModel.
        /// </summary>
        public EmitterCombinerEditorViewModel EmitterCombinerEditorViewModel { get; private set; }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
