﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UILogic.ViewModels.Extenders;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the emitter texture group.
    /// </summary>
    public class EmitterColorPageViewModel : PropertyPageViewModel<EmitterColorGroupData>, IModificationFlagOwner, IPropertyPageOwner
    {
        /// <summary>Extender for manipulating child property pages.</summary>
        private PropertyPageOwnerViewModelExtender propertyPageOwnerExtender;

        /// <summary>View model for the emitter color.</summary>
        private EmitterColorParticleViewModel particleColor = null;

        /// <summary>View model for the emitter global color.</summary>
        private EmitterColorEmitterColorViewModel emitterColor = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterColorPageViewModel(HierarchyViewModel parent, EmitterColorGroupData dataModel)
            : base(parent, dataModel)
        {
            this.propertyPageOwnerExtender = new PropertyPageOwnerViewModelExtender(this);

            this.SetChildViewModel(
                ref this.particleColor,
                new EmitterColorParticleViewModel(this, dataModel.ParticleColor));

            this.SetChildViewModel(
                ref this.emitterColor,
                new EmitterColorEmitterColorViewModel(this, dataModel.EmitterColor));

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// The default property page view model to use
        /// on the first time the workspace node is selected.
        /// </summary>
        public HierarchyViewModel DefaultPropertyPageViewModel
        {
            get { return this.particleColor; }
        }

        /// <summary>
        /// Get or set the selected property page.
        /// </summary>
        public HierarchyViewModel SelectedPropertyPage
        {
            get
            {
                return this.propertyPageOwnerExtender.SelectedPropertyPage;
            }

            set
            {
                this.propertyPageOwnerExtender.SelectedPropertyPage = value;
                this.OnPropertyChanged();
            }
        }

        /// <summary>
        /// Get the particle color view model.
        /// </summary>
        public EmitterColorParticleViewModel ParticleColor
        {
            get { return this.particleColor; }
        }

        /// <summary>
        /// Get the emitter color view model.
        /// </summary>
        public EmitterColorEmitterColorViewModel EmitterColor
        {
            get { return this.emitterColor; }
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel
        {
            get;
            private set;
        }
    }
}
