﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UILogic.Properties;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the EmitterColorAlphaProcessingViewModel.
    /// </summary>
    public class EmitterColorAlphaProcessingViewModel : PropertyGroupViewModel<EmitterColorAlphaProcessingData>, IModificationFlagOwner
    {
        /// <summary>
        /// 変更の対象に含めないプロパティ名のリストです.
        /// </summary>
        private readonly string[] ignorePropertyNames = new string[]
        {
            "SoftParticleVertexGroupVisibility",
            "SoftParticleFragmentGroupVisibility",
            "FresnelAlphaVertexGroupVisibility",
            "FresnelAlphaFragmentGroupVisibility",
            "DecalGroupVisibility",
        };

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterColorAlphaProcessingViewModel(
            HierarchyViewModel parent, EmitterColorAlphaProcessingData dataModel)
            : base(parent, dataModel)
        {
            this.SoftParticleProccessTypeItems = new []
            {
                new KeyValuePair<string, object>(Resources.EmitterColorParticleProcessNone, 0),
                new KeyValuePair<string, object>(Resources.EmitterColorParticleProcessVertex, 1),
                new KeyValuePair<string, object>(Resources.EmitterColorParticleProcessFragment, 2),
                new KeyValuePair<string, object>(Resources.EmitterColorParticleProcessOcclusionCheck, 3),
            };

            this.FresnelAlphaProcessTypeItems = new []
            {
                new KeyValuePair<string, object>(Resources.EmitterColorFresnelProcessNone, 0),
                new KeyValuePair<string, object>(Resources.EmitterColorFresnelProcessVertex, 1),
                new KeyValuePair<string, object>(Resources.EmitterColorFresnelProcessFragment, 2),
            };

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
            this.ModificationFlagViewModel.AddIgnoreProperties(this.ignorePropertyNames);
        }

        /// <summary>処理方法タイプの項目を取得します.</summary>
        public IEnumerable<KeyValuePair<string, object>> SoftParticleProccessTypeItems { get; private set; }

        /// <summary>
        /// フレネルアルファの処理タイプの項目を取得します.
        /// </summary>
        public IEnumerable<KeyValuePair<string, object>> FresnelAlphaProcessTypeItems { get; private set; }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
