﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the EmitterBasicRandomViewModel.
    /// </summary>
    public class EmitterBasicRandomViewModel : PropertyGroupViewModel<EmitterBasicRandomData>, IModificationFlagOwner
    {
        /// <summary>
        /// 変更の対象に含めないプロパティ名のリストです.
        /// </summary>
        private readonly string[] ignorePropertyNames = new string[]
        {
            "EmitterBasicRandomComment",
        };

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterBasicRandomViewModel(
            HierarchyViewModel parent, EmitterBasicRandomData dataModel)
            : base(parent, dataModel)
        {
            this.RandomTypeItems = new KeyValuePair<string, object>[]
            {
                new KeyValuePair<string, object>(
                    Properties.Resources.EmitterBasicTypeRandom0, 0),
                new KeyValuePair<string, object>(
                    Properties.Resources.EmitterBasicTypeRandom1, 1),
                new KeyValuePair<string, object>(
                    Properties.Resources.EmitterBasicTypeRandom2, 2),
            };

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
            this.ModificationFlagViewModel.AddIgnoreProperties(this.ignorePropertyNames);
        }

        /// <summary>
        /// ランダムタイプを取得します.
        /// </summary>
        public IEnumerable<KeyValuePair<string, object>> RandomTypeItems
        {
            get;
            private set;
        }

        /// <summary>
        /// 乱数タイプを設定または取得します.
        /// </summary>
        public int RandomType
        {
            get
            {
                return this.GetDataModelValue(() => this.RandomType);
            }

            set
            {
                this.SetDataModelValue(value, () => this.RandomType);

                // プロパティ変更通知.
                this.OnPropertyChanged(() => this.EmitterBasicRandomComment);
             }
        }

        /// <summary>
        /// 乱数タイプに対応するコメント.
        /// </summary>
        public string EmitterBasicRandomComment
        {
            get
            {
                if (this.RandomType == 0)
                {
                    return Properties.Resources.EmitterBasicLabelRandom0Comment;
                }
                else if (this.RandomType == 1)
                {
                    return Properties.Resources.EmitterBasicLabelRandom1Comment;
                }
                else if (this.RandomType == 2)
                {
                    return Properties.Resources.EmitterBasicLabelRandom2Comment;
                }

                return string.Empty;
            }
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
