﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.Foundation.Texture;

namespace EffectMaker.TextureManager.Loader
{
    /// <summary>
    /// テクスチャローダインターフェース
    /// </summary>
    internal interface ITextureLoader
    {
        /// <summary>
        /// テクスチャファイルが読み込めるかどうか取得します。
        /// </summary>
        /// <param name="filePath">確認するファイルパス</param>
        /// <returns>テクスチャファイルが読み込めるときtrue、それ以外はfalseを返します。</returns>
        bool CanLoad(string filePath);

        /// <summary>
        /// テクスチャファイルをロードします。
        /// </summary>
        /// <param name="filePath">ロードするファイルパス</param>
        /// <returns>テクスチャのロード結果を返します。</returns>
        LoadTextureResult Load(string filePath);
    }
}
