﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.DataModelLogic.BinaryData
{
    /// <summary>
    /// Class for the definition of a fixed-size binary data field.
    /// </summary>
    public class FixedSizeBinaryFieldDefinition : BinaryFieldDefinition
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="size">The size for the fixed-size binary field in bytes.</param>
        /// <param name="sendModificationType">The type of message to send if data is modified.</param>
        /// <param name="converterDef">The converter definition.</param>
        /// <param name="structDef">The definition of a binary structure for the field.</param>
        /// <param name="inputProperties">The array of definition of the input properties.</param>
        public FixedSizeBinaryFieldDefinition(
            int size,
            SendModificationTypes sendModificationType,
            ConverterDefinition converterDef,
            BinaryStructDefinition structDef,
            params InputPropertyDefinition[] inputProperties) :
            base(sendModificationType, converterDef, structDef, inputProperties)
        {
            this.FixedSize = size;
        }

        /// <summary>
        /// Get or set the constant size of the binary field.
        /// </summary>
        public int FixedSize { get; set; }

        /// <summary>
        /// Create an instance with the definition.
        /// </summary>
        /// <param name="parent">The parent binary data structure instance.</param>
        /// <returns>The created instance.</returns>
        public override BinaryFieldInstance CreateInstance(BinaryStructInstance parent)
        {
            return new FixedSizeBinaryFieldInstance(parent, this);
        }
    }
}
