﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// Blocks any data model property modified event within the block.
    /// </summary>
    public class DataModelPropertyModifiedEventBlock : IDisposable
    {
        /// <summary>The block count.</summary>
        private static int blockCount = 0;

        /// <summary>
        /// Constructor.
        /// </summary>
        public DataModelPropertyModifiedEventBlock()
        {
            ++blockCount;
        }

        /// <summary>
        /// Get the flag indicating whether if the data model property
        /// modified events should be blocked.
        /// </summary>
        public static bool IsDataModelPropertyModifiedEventBlocked
        {
            get
            {
                return blockCount > 0;
            }
        }

        /// <summary>
        /// Dispose this instance.
        /// </summary>
        public void Dispose()
        {
            --blockCount;
        }
    }
}
