﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.BusinessLogic.ViewerMessages
{
    /// <summary>
    /// Utility for viewer messages.
    /// </summary>
    public static class MessageUtility
    {
        /// <summary>
        /// Get the asset type of the data model.
        /// </summary>
        /// <param name="dataModel">The data model.</param>
        /// <returns>The asset type.</returns>
        public static AssetTypes GetDataModelAssetType(DataModelBase dataModel)
        {
            AssetTypes assetType = AssetTypes.Unknown;
            if (dataModel is EmitterSetData)
            {
                assetType = AssetTypes.EmitterSet;
            }
            else if (dataModel is EmitterData)
            {
                assetType = AssetTypes.Emitter;
            }
            else if (dataModel is PreviewData)
            {
                assetType = AssetTypes.Preview;
            }
            else if (dataModel is ViewerData)
            {
                assetType = AssetTypes.ViewerData;
            }
            else if (dataModel is ModelData)
            {
                assetType = AssetTypes.ViewerModel;
            }

            return assetType;
        }
    }
}
