﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.BusinessLogic.UserData
{
    /// <summary>
    /// UDD2.0ファイルコンバータのインターフェイスです。
    /// </summary>
    public interface IUdd2Converter
    {
        /// <summary>
        /// ユーザーデータ定義の対象を取得します。
        /// </summary>
        string UserDataType { get; }

        /// <summary>
        /// ユーザーデータ定義の名前を取得します。
        /// </summary>
        string DefineName { get; }

        /// <summary>
        /// エラー報告を取得します。
        /// </summary>
        string ErrorReport { get; }

        /// <summary>
        /// データモデル名を取得します。
        /// </summary>
        string DataModelName { get; }

        /// <summary>
        /// データモデルのソースコードを取得します。
        /// </summary>
        string DataModelCode { get; }

        /// <summary>
        /// UIを定義するXamlコードを取得します。
        /// </summary>
        string XamlCode { get; }

        /// <summary>
        /// XPath テーブルを取得します。
        /// </summary>
        string XPathTable { get; }

        /// <summary>
        /// バイナリコンバート定義のソースコードを取得します。
        /// </summary>
        string BinaryConversionInfoCode { get; }

        /// <summary>
        /// ユーザーデータ定義を読み込みます。
        /// </summary>
        /// <param name="inputFilePath">入力ファイルパス</param>
        /// <returns>成功すればtrue,失敗したらfalse.</returns>
        bool LoadDefinition(string inputFilePath);

        /// <summary>
        /// ユーザーデータ定義から各種コードを生成します。
        /// </summary>
        /// <returns>成功すればtrue,失敗したらfalse.</returns>
        bool Convert();

        /// <summary>
        /// ユーザーデータ定義から各種ファイルを出力します。
        /// </summary>
        /// <param name="outputFolderPath">コンバート結果出力フォルダパス</param>
        /// <returns>成功すればtrue,失敗したらfalse.</returns>
        bool ConvertToFile(string outputFolderPath);
    }
}
