﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.BusinessLogic.ProjectConfig;

namespace EffectMaker.BusinessLogic.RuntimeOptions
{
    /// <summary>
    /// シェーダコンバートオプションの列挙型
    /// </summary>
    public enum ShaderConvertOption
    {
        /// <summary>
        /// 何もしない（デフォルト）
        /// </summary>
        Fast,

        /// <summary>
        /// サイズを小さくする
        /// </summary>
        Small,

        /// <summary>
        /// キャッシュを利用してコンバートを高速化
        /// </summary>
        Cache,

        /// <summary>
        /// キャッシュを作成
        /// </summary>
        BuildCache,
    }

    /// <summary>
    /// 実行時オプションを管理します。
    /// </summary>
    public class RuntimeOptions
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public RuntimeOptions()
        {
            this.IsCommandLineMode = false;
            this.NoShaderSource = false;
            this.ShaderConvertOption = ShaderConvertOption.Fast;
            this.ShaderCacheDirectory = string.Empty;
            this.JobsNumber = 1;
            this.IsBinaryConverting = false;
            this.IsSubBinaryConverting = false;
            this.CurrentCulture = string.Empty;
            this.FileEventMerge = new FileEventProjectConfig();
        }

        /// <summary>
        /// コマンドラインモードかどうか取得または設定します。
        /// </summary>
        public bool IsCommandLineMode { get; set; }

        /// <summary>
        /// バイナリのシェーダソースコードを省略するかどうか取得または設定します。
        /// </summary>
        public bool NoShaderSource { get; set; }

        /// <summary>
        /// シェーダコンバートオプションを取得または設定します。
        /// </summary>
        public ShaderConvertOption ShaderConvertOption { get; set; }

        /// <summary>
        /// シェーダキャッシュディレクトリを取得または設定します。
        /// </summary>
        public string ShaderCacheDirectory { get; set; }

        /// <summary>
        /// 並列実行するジョブ数を取得または設定します。
        /// </summary>
        public int JobsNumber { get; set; }

        /// <summary>
        /// 並列実行するジョブ数を指定したか否かを取得または設定します。
        /// </summary>
        public bool IsJobsNumberAssigned { get; set; }

        /// <summary>
        /// バイナリコンバート処理中か否かを取得または設定します。
        /// </summary>
        public bool IsBinaryConverting { get; set; }

        /// <summary>
        /// サブバイナリのコンバート処理中か否かを取得または設定します。
        /// </summary>
        public bool IsSubBinaryConverting { get; set; }

        /// <summary>
        /// 現在の言語環境を取得または設定します。
        /// </summary>
        public string CurrentCulture { get; set; }

        /// <summary>
        /// ファイルイベントのプロジェクト設定とユーザー設定をマージしたパスを設定します。
        /// </summary>
        public FileEventProjectConfig FileEventMerge { get; set; }
    }
}
