﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

using EffectMaker.Foundation.Serialization;

namespace EffectMaker.BusinessLogic.Options
{
    /// <summary>
    /// World Scale options.
    /// </summary>
    public class WorldScaleOptions : OptionsBase
    {
        /// <summary>
        /// Initializes the WorldScaleOptions instance.
        /// </summary>
        public WorldScaleOptions()
        {
        }

        /// <summary>
        /// Copy the WorldScaleOptions instance.
        /// </summary>
        /// <param name="src">The source optins to copy from.</param>
        public WorldScaleOptions(WorldScaleOptions src)
            : this()
        {
            this.Set(src);
        }

        /// <summary>
        /// Gets or sets position, speed and size range.
        /// </summary>
        [XmlAttribute]
        public float PositionSpeedSize { get; set; }

        /// <summary>
        /// Gets or sets time.
        /// </summary>
        [XmlAttribute]
        public int Time { get; set; }

        /// <summary>
        /// Gets or sets the display scale.
        /// </summary>
        [XmlAttribute]
        public float DisplayScale { get; set; }

        /// <summary>
        /// Set data from the source options.
        /// </summary>
        /// <param name="src">The source options.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var options = src as WorldScaleOptions;
            if (options == null)
            {
                return false;
            }

            this.PositionSpeedSize = options.PositionSpeedSize;
            this.Time = options.Time;
            this.DisplayScale = options.DisplayScale;

            return true;
        }

        /// <summary>
        /// Deserializes from the given XML node.
        /// </summary>
        /// <param name="context">The data context needed for the deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            this.PositionSpeedSize = this.ReadAttribute(context, "PositionSpeedSize", this.PositionSpeedSize);
            this.Time = this.ReadAttribute(context, "Time", this.Time);
            this.DisplayScale = this.ReadAttribute(context, "DisplayScale", this.DisplayScale);

            return true;
        }

        /// <summary>
        /// Serializes this object to a XML node.
        /// </summary>
        /// <param name="context">The data context needed for the serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            this.WriteAttribute(context, "PositionSpeedSize", this.PositionSpeedSize);
            this.WriteAttribute(context, "Time", this.Time);
            this.WriteAttribute(context, "DisplayScale", this.DisplayScale);

            return true;
        }
    }
}
