﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
#region File Description
#endregion

namespace EffectMaker.Communicator
{
    #region Using Statements
    using System;
    using System.Linq;
    #endregion

    /// <summary>
    /// メッセージです.
    /// </summary>
    public class Message
    {
        #region Public Properties

        /// <summary>
        /// パケットバッファのサイズを設定/取得します.
        /// </summary>
        public int Size { get; set; }

        /// <summary>
        /// パケットバッファの設定/取得を行います.
        /// </summary>
        public byte[] Buffer { get; set; }

        #endregion

        #region Public Methods

        /// <summary>
        /// パケットをクリアします.
        /// </summary>
        public void Clear()
        {
            // ゼロクリア.
            this.Size = 0;

            // nullクリア.
            this.Buffer = null;
        }

        /// <summary>
        /// メッセージが等価であるかどうかをチェックします.
        /// </summary>
        /// <param name="message">比較するメッセージ</param>
        /// <returns>メッセージが等価であればtrue, 非等価であればfalseを返却します.</returns>
        public bool IsEqual(Message message)
        {
            // サイズが同じであるかチェック.
            if (this.Size != message.Size)
            {
                return false;
            }

            // バッファを比較してその結果を返却.
            return this.Buffer.SequenceEqual(message.Buffer);
        }
        #endregion
    }
}
