﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.Foundation.Interfaces
{
    /// <summary>
    /// Represent a value transform over time.
    /// </summary>
    /// <typeparam name="T">The type of value to transform.</typeparam>
    public interface IValueTransform<T>
    {
        /// <summary>
        /// Set the inital value.
        /// </summary>
        /// <param name="initialValue">The initial working value.</param>
        void Initialize(T initialValue);

        /// <summary>
        /// Transform the input value to a new one.
        /// </summary>
        /// <param name="value">The input value to transform.</param>
        /// <returns>The output transformed value.</returns>
        T TransformValue(T value);
    }
}
