﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.Foundation.Interfaces
{
    /// <summary>
    /// An ICollection(T) where items can be accessed by index.
    /// </summary>
    /// <typeparam name="T">The specific type of items.</typeparam>
    public interface IIndexableCollection<T> : ICollection<T>
    {
        /// <summary>
        /// Gets the collection item by its index.
        /// </summary>
        /// <param name="index">The index of the item to retrieve.</param>
        /// <returns>Returns the collection item.</returns>
        T this[int index] { get; }
    }
}
