﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.Foundation.Interfaces
{
    /// <summary>
    /// Represent a component that can execute a execution.
    /// </summary>
    public interface IExecutionSource
    {
        /// <summary>
        /// Raised before the Executable gets executed.
        /// </summary>
        event EventHandler BeforeExecute;

        /// <summary>
        /// Raised after the Executable gets executed.
        /// </summary>
        event EventHandler AfterExecute;

        /// <summary>
        /// Gets the executable to execute.
        /// </summary>
        IExecutable Executable { get; set; }

        /// <summary>
        /// Gets the parameter to provide to the execution.
        /// </summary>
        object ExecutionParameter { get; set; }
    }
}
