﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.Foundation.Interfaces
{
    /// <summary>
    /// An interface that defines the possibility to report exception occuring.
    /// </summary>
    public interface IExceptionReporter
    {
        /// <summary>
        /// Report that an exception occured.
        /// </summary>
        /// <param name="error">The exception that occured.</param>
        void Report(Exception error);
    }

    /// <summary>
    /// A null exception reporter that silently unreports.
    /// </summary>
    public class NullExceptionReporter : IExceptionReporter
    {
        /// <summary>
        /// Gets the default NullExceptionReporter instance.
        /// </summary>
        public static readonly IExceptionReporter Default = new NullExceptionReporter();

        /// <summary>
        /// Report that an exception occured.
        /// </summary>
        /// <param name="error">The exception that occured.</param>
        public void Report(Exception error)
        {
        }
    }
}
