﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectMaker.Foundation.EventArguments;

namespace EffectMaker.Foundation.EventArguments
{
    /// <summary>
    /// Extended ValueChangedEventArgs class.
    /// </summary>
    public class ValueChangedExEventArgs : ValueChangedEventArgs<object>
    {
        /// <summary>
        /// Initializes the ValueChangedExEventArgs instance.
        /// </summary>
        /// <param name="oldValue">The value before change.</param>
        /// <param name="newValue">The new value after change.</param>
        /// <param name="isChanging">Flag telling if the value keeps changing or
        /// if it has changed and done.</param>
        /// <param name="customParameter">The custom parameter.</param>
        /// <param name="issueCommand">コマンドを履歴に積みたいかどうか(デフォルトtrue)</param>
        public ValueChangedExEventArgs(
            object oldValue,
            object newValue,
            bool isChanging,
            object customParameter = null,
            bool issueCommand = true)
            : base(oldValue, newValue)
        {
            this.IsChanging = isChanging;
            this.CustomParameter = customParameter;
            this.IssueCommand = issueCommand;
        }

        /// <summary>
        /// Gets whether the value is keep changing (throttling)
        /// or if the change is done once for good.
        /// </summary>
        public bool IsChanging { get; private set; }

        /// <summary>
        /// Gets a custom parameter.
        /// </summary>
        public object CustomParameter { get; private set; }

        /// <summary>
        /// コマンドを履歴に積みたいかどうか
        /// </summary>
        public bool IssueCommand { get; private set; }
    }

    /// <summary>
    /// Extended ValueChangedEventArgs class.
    /// </summary>
    /// <typeparam name="T">The type of the subjacent value.</typeparam>
    public class ValueChangedExEventArgs<T> : ValueChangedExEventArgs
    {
        /// <summary>
        /// Initializes the ValueChangedExEventArgs instance.
        /// </summary>
        /// <param name="oldValue">The value before change.</param>
        /// <param name="newValue">The new value after change.</param>
        /// <param name="isChanging">Flag telling if the value keeps changing or
        /// if it has changed and done.</param>
        /// <param name="customParameter">The custom parameter.</param>
        /// <param name="issueCommand">コマンドを履歴に積みたいかどうか(デフォルトtrue)</param>
        public ValueChangedExEventArgs(
            T oldValue,
            T newValue,
            bool isChanging,
            object customParameter = null,
            bool issueCommand = true)
            : base(oldValue, newValue, isChanging, customParameter, issueCommand)
        {
        }

        /// <summary>
        /// Gets the old value.
        /// </summary>
        public new T OldValue
        {
            get { return (T)base.OldValue; }
        }

        /// <summary>
        /// Gets the new value.
        /// </summary>
        public new T NewValue
        {
            get { return (T)base.NewValue; }
        }
    }
}
