﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectMaker.Foundation.Extensions;

namespace EffectMaker.Foundation.Disposables
{
    /// <summary>
    /// Represent a set of disposable objects.
    /// </summary>
    public class AggregateDisposable : IDisposable
    {
        /// <summary>
        /// An array of aggregated IDisposable instance.
        /// </summary>
        private IDisposable[] disposables;

        /// <summary>
        /// Create an AggregatedDisposable object.
        /// </summary>
        /// <param name="disposables">All the disposables to be disposed
        /// when the current object will get disposed.</param>
        public AggregateDisposable(params IDisposable[] disposables)
        {
            this.disposables = disposables;
        }

        /// <summary>
        /// Dispose the object and all the aggregated disposables provides at the constructor.
        /// </summary>
        public void Dispose()
        {
            if (this.disposables != null)
            {
                this.disposables.ForEach(d => d.Dispose());
            }

            this.disposables = null;
        }
    }
}
