﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.Foundation.Coercers
{
    /// <summary>
    /// Coercer that transmit input to output as is.
    /// </summary>
    public class PassThroughCoercer : ICoercer
    {
        /// <summary>
        /// Gets the default PassThroughtCoercer instance;
        /// </summary>
        public static readonly ICoercer Default = new PassThroughCoercer();

        /// <summary>
        /// Transmit the input value to output without applying any transform.
        /// </summary>
        /// <param name="input">Input value to coerce.</param>
        /// <returns>Returns the input value as it.</returns>
        public object Coerce(object input)
        {
            return input;
        }
    }
}
