﻿/*--------------------------------------------------------------------------------*
Copyright (C)Nintendo All rights reserved.

These coded instructions, statements, and computer programs contain proprietary
information of Nintendo and/or its licensed developers and are protected by
national and international copyright laws. They may not be disclosed to third
parties or copied or duplicated in any form, in whole or in part, without the
prior written consent of Nintendo.

The content herein is highly confidential and should be handled accordingly.
*--------------------------------------------------------------------------------*/
#pragma once

#include <sstream>

#include <Windows.h>

#include "gfxTool_ShaderConverterDll.h"

namespace EffectMaker {
namespace SpecGeneric {
namespace Shader {

//---------------------------------------------------------------------------
//! @brief  シェーダコンバーターのログ出力を管理します。
//---------------------------------------------------------------------------
class ShaderConverterLogHandler
{
public:
    //---------------------------------------------------------------------------
    //! @brief  コンストラクタです。
    //---------------------------------------------------------------------------
    ShaderConverterLogHandler();

    //---------------------------------------------------------------------------
    //! @brief  デストラクタです。
    //---------------------------------------------------------------------------
    ~ShaderConverterLogHandler();

    //---------------------------------------------------------------------------
    //! @brief     出力ハンドルを初期化します。
    //! @param[in] pShaderConverterDll ShaderConverterのDLLアセンブリ
    //---------------------------------------------------------------------------
    void Initialize(nn::gfxTool::ShaderConverterDll* pShaderConverterDll);

    //---------------------------------------------------------------------------
    //! @brief  出力ハンドルを破棄します。
    //---------------------------------------------------------------------------
    void Release();

    //---------------------------------------------------------------------------
    //! @brief  シェーダコンバータのログ出力先を自作の出力ハンドルに設定します。
    //---------------------------------------------------------------------------
    void ConnectPipe();

    //---------------------------------------------------------------------------
    //! @brief  シェーダコンバータのログ出力先をデフォルトの出力ハンドルに戻します。
    //---------------------------------------------------------------------------
    void DisconnectPipe();

    //---------------------------------------------------------------------------
    //! @brief   標準ログとして出力されたデータを取得します。
    //!
    //! @return  標準ログとして出力された文字列データを返します。
    //---------------------------------------------------------------------------
    System::String^ ReadDefaultLogData();

    //---------------------------------------------------------------------------
    //! @brief   警告ログとして出力されたデータを取得します。
    //!
    //! @return  警告ログとして出力された文字列データを返します。
    //---------------------------------------------------------------------------
    System::String^ ReadWarningLogData();

    //---------------------------------------------------------------------------
    //! @brief   エラーログとして出力されたデータを取得します。
    //!
    //! @return  エラーログとして出力された文字列データを返します。
    //---------------------------------------------------------------------------
    System::String^ ReadErrorLogData();

private:
    //---------------------------------------------------------------------------
    //! @brief     パイプが出力されたデータを吸い出します。
    //! @param[in] pArg スレッド引数
    //!
    //! @return    スレッドリザルトを返します。
    //---------------------------------------------------------------------------
    static unsigned _stdcall ChooChooDrain(void* pArg);

private:
    //---------------------------------------------------------------------------
    //! @brief  パイプ情報です。
    //---------------------------------------------------------------------------
    struct PipeInfo
    {
    public:
        PipeInfo()
            : readHandle(), writeHandle(), drainStream()
        {
        }

    public:
        HANDLE            readHandle;   //!< 入力ハンドル
        HANDLE            writeHandle;  //!< 出力ハンドル

        std::stringstream drainStream;  //!< 吸い出しストリーム
    };

    nn::gfxTool::ShaderConverterDll* m_pShaderConverterDll;  //!< ShaderConverterのDLLアセンブリ

    HANDLE   m_drainThread;      //!< パイプの吸い出しスレッド
    HANDLE   m_disconnectEvent;  //!< パイプの切断イベント

    HANDLE   m_stdOutputHandle;  //!< 標準出力のハンドル
    HANDLE   m_stdErrorHandle;   //!< 標準エラー出力のハンドル

    PipeInfo m_defaultPipe;      //!< 標準出力のパイプ
    PipeInfo m_warningPipe;      //!< 警告出力のパイプ
    PipeInfo m_errorPipe;        //!< エラー出力のパイプ
};

}
}
}
