﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShaderConverterWrapper_PCH.h"
#include "NativeMessageForwarder.h"

using namespace EffectMaker::ShaderConverterLib;


namespace EffectMaker {
namespace ShaderConverterWrapper {

    /// <summary>
    /// Constructor.
    /// </summary>
    /// <param name="pAppForwarder">The message forwarder set from the application.</param>
    NativeMessageForwarder::NativeMessageForwarder(IDotNetMessageForwarder ^pAppForwarder) :
        m_appForwarder(pAppForwarder)
    {
    }

    /// <summary>
    /// Destructor.
    /// </summary>
    NativeMessageForwarder::~NativeMessageForwarder()
    {
        m_appForwarder = nullptr;
    }

    /// <summary>
    /// Forward message to the application.
    /// </summary>
    /// <param name="pMessage">The message to output.</param>
    void NativeMessageForwarder::ForwardMessage(const MessageBase *pMessage)
    {
        if (nullptr == static_cast<IDotNetMessageForwarder^>(this->m_appForwarder))
        {
            return;
        }

        // Forward the message.
        this->m_appForwarder->ForwardMessage(gcnew DotNetMessage(pMessage));
    }

} // namespace ShaderConverterWrapper
} // namespace EffectMaker
