﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShaderCodeGeneratorGeneric_ShaderConverter_H__
#define __ShaderCodeGeneratorGeneric_ShaderConverter_H__

#pragma warning(disable:4251)

#include "ShaderCodeGeneratorGenericUtility.h"
#include <nw/eft/eft2_Binary.h>
#include <deque>

namespace EffectMaker {
namespace ShaderCodeGeneratorGeneric {
    ////////////////////////////////////
    // ShaderConverter class
    ////////////////////////////////////
    class LIB_API ShaderConverter
    {
    public:
        //------------------------------------------------------------------------------
        //      コンストラクタ
        //------------------------------------------------------------------------------
        ShaderConverter();

        //------------------------------------------------------------------------------
        //      デストラクタ
        //------------------------------------------------------------------------------
        ~ShaderConverter();

        //------------------------------------------------------------------------------
        //      初期化する
        //------------------------------------------------------------------------------
        void Initialize(ShaderCodeListCpp* pShaderCodes);

        //------------------------------------------------------------------------------
        //      シェーダソースコードの生成
        //------------------------------------------------------------------------------
        bool GenerateShaderCode( ShaderConverterEmitterData* pEmitterData,
                                 char**                      ppVertexShader,
                                 s32*                        pVertexShaderSize,
                                 char**                      ppFragmentShader,
                                 s32*                        pFragmentShaderSize,
                                 char**                      ppComputeShader,
                                 s32*                        pComputeShaderSize,
                                 u32                         userDefineIndex = 0);

        //------------------------------------------------------------------------------
        //      VfxのShaderKeyとシェーダソースコードの生成
        //------------------------------------------------------------------------------
        bool GenerateVfxShaderKeyAndCodes( ShaderConverterEmitterData* pEmitterData,
                                           char**                      ppShaderKey,
                                           s32*                        pShaderKeySize,
                                           char**                      ppVertexShader,
                                           s32*                        pVertexShaderSize,
                                           char**                      ppFragmentShader,
                                           s32*                        pFragmentShaderSize,
                                           char**                      ppComputeShader,
                                           s32*                        pComputeShaderSize,
                                           u32                         userDefineIndex = 0 );

    private:
        //------------------------------------------------------------------------------
        //      頂点シェーダコードを生成する
        //------------------------------------------------------------------------------
        u32 GenerateVertexShaderCode( char* shaderCodeBuf,
                                      char* compileSettings,
                                      u32   settingSize,
                                      char* overrideVertexShader,
                                      s32   overrideVertexShaderLength,
                                      bool  useCustomShader,
                                      s32   customShaderIndex,
                                      s32   reservedShaderIndex,
                                      bool  useStreamOut = false,
                                      bool  expandAllShaders = false);

        //------------------------------------------------------------------------------
        //      フラグメントシェーダコードを生成する
        //------------------------------------------------------------------------------
        u32 GenerateFragmentShaderCode( char* shaderCodeBuf,
                                        char* compileSettings,
                                        u32   settingSize,
                                        char* overrideFragmentSader,
                                        s32   overrideFragmentShaderLength,
                                        bool  useCustomShader,
                                        s32   customShaderIndex,
                                        s32   reservedShaderIndex,
                                        bool  useStreamOut = false,
                                        bool  expandAllShaders = false);

        //------------------------------------------------------------------------------
        //      エミッタプラグインデータを取得する
        //------------------------------------------------------------------------------
        template<class T> void* GetEmitterPlugin( T* binaryData );

        //------------------------------------------------------------------------------
        //      カスタムフィールドデータを取得する
        //------------------------------------------------------------------------------
        template<class T_out, class T_in> T_out* GetCustomField( T_in* binaryData );

        //------------------------------------------------------------------------------
        //      フィールドデータの存在チェック
        //------------------------------------------------------------------------------
        template<class T> bool IsFieldExist( T* binaryData );

        ShaderCodeListCpp* mShaderCodes;

        char*              szVshCodeCompositeBuffer;
        char*              szFshCodeCompositeBuffer;

        bool               mIsField;                      // フィールドがあるかどうか？
        s32                mReservedShaderIndex;          // Reserved shader index. (-1 if not used)
        s32                mCustomShaderIndex;            // CustomShaderインデックス
    };

} // namespace ShaderCodeGeneratorGeneric
} // namespace EffectMaker


#endif // __ShaderCodeGeneratorGeneric_ShaderConverter_H__
