﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShaderCodeGeneratorGeneric_PCH.h"
#include "ShaderCodeGeneratorGenericUtility.h"

//#include <io.h>
//#include <direct.h>
//#include <stdafx.h>

namespace EffectMaker {
namespace ShaderCodeGeneratorGeneric {

//------------------------------------------------------------------------------
//      シェーダソースコードのコピー
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//      コンストラクタ
//------------------------------------------------------------------------------
CopyShaderCode::CopyShaderCode( char* dstBuf )
{
    mBufAvailSize     = ShaderCodeBufferSize;
    mShaderCodeLength = 0;
    mDstBuf           = dstBuf;
}

void CopyShaderCode::CopyCode( const char* srcBuf, u32 size )
{
    strcat_s( mDstBuf, mBufAvailSize, srcBuf );

    mShaderCodeLength += size;
    mBufAvailSize     -= size;
}

/*
//------------------------------------------------------------------------------
//      シェーダキャッシュ
//------------------------------------------------------------------------------
void ShaderCache::ReadShaderCache( FILE* fp )
{
    // file size分読み込む
    fpos_t size;
    fseek(fp, 0, SEEK_END);
    fgetpos(fp, &size);
    fseek(fp, 0, SEEK_SET);
    this->mBinary = new char[size];
    memset(this->mBinary, 0, size);

    u32 readSize = 0;
    if ( (readSize = static_cast<u32>(fread_s( this->mBinary, size, 1, size, fp ))) > 0 )
    {
        fclose( fp );
        if ( *((u32*)this->mBinary) !=  EFT_MAKE_TAG('S', 'H', 'C', 'A') )
        // 正しくないShaderCache fileなのでreturnする
        {
            return;
        }

        // shader個数を確認して、それぞれのポインタを設定する
        this->mShaderInfo    = (shaderBinaryInfo*)this->mBinary;
        this->mShaderTable   = (shaderBinaryTable*)( this->mBinary + sizeof(shaderBinaryInfo) );
        this->mShaderBinary = (char*)this->mShaderTable + ( this->mShaderInfo->numShader * sizeof(shaderBinaryTable) );

        // gsh shaderBinaryから頂点、フラグメントシェーダの個数を取得する。
        mNumVertexShader = GDFGetVertexShaderNum32( mShaderBinary );
        mNumFragShader = GDFGetPixelShaderNum32(  mShaderBinary );

        mVshArray  = new GX2VertexShader *[mNumVertexShader];
        mFshArray  = new GX2PixelShader  *[mNumFragShader];

        // gsh shaderBinaryからGX2VertexShaderに展開する。
        for ( u32 i = 0; i < mNumVertexShader; i++ )
        {
            mVshArray[i] = GDFGetVertexShader32To64( i, mShaderBinary );
        }

        // gsh shaderBinaryからGX2PixelShaderに展開する。
        for ( u32 i = 0; i < mNumFragShader; i++ )
        {
            mFshArray[i] = GDFGetPixelShader32To64( i, mShaderBinary );
        }
    }
}

//------------------------------------------------------------------------------
// Write Shader Cache.
//------------------------------------------------------------------------------
void ShaderCache::WriteShaderCache( void* gshBinary,
                                    u32   gshBinarySize,
                                    u32   numShader,
                                    ShaderKeyInfo* shaderKeyArray,
                                    char* shaderCachePath )
{
    // シェーダサイズを計算する。

    u32 binSize   = sizeof(shaderBinaryInfo) + numShader * sizeof(shaderBinaryTable) + gshBinarySize;
    this->mBinary = new char[binSize];

    this->mShaderInfo = (shaderBinaryInfo*)this->mBinary;
    mShaderInfo->tag              = EFT_MAKE_TAG('S', 'H', 'C', 'A');
    mShaderInfo->numShader        = numShader;
    mShaderInfo->totalShaderSize  = gshBinarySize;

    this->mShaderTable    = (shaderBinaryTable *)(mBinary + sizeof(shaderBinaryInfo) );       // shaderBinaryTableの先頭
    this->mShaderBinary  = (char*)mShaderTable + ( numShader * sizeof(shaderBinaryTable) );   // shaderBinaryの先頭
    char* pShaderCurrent = this->mShaderBinary;
    for (u32 i = 0; i < numShader; i++ )
    {
        // shaderBinaryTableを設定する
        memcpy( &this->mShaderTable[i].shaderKeyInfo, &shaderKeyArray[i], sizeof(ShaderKeyInfo) );
    }

    memcpy( pShaderCurrent, gshBinary, gshBinarySize );

    // shaderCache.binを書き出す。
    FILE* fp;
    if ( fopen_s( &fp, shaderCachePath, "wb" ) == 0 )
    {
        fwrite( mBinary, binSize, 1, fp );
        fclose( fp );
    }
}

s32 ShaderCache::IsFindCache( ShaderKeyInfo* shaderKey )
{
    u32 findCache = -1;
    if ( ( this->mShaderInfo == NULL) || (this->mShaderTable == NULL ) || ( this->mShaderBinary == NULL ) )
        return findCache;

    for( u32 i = 0; i < this->mShaderInfo->numShader; i++ )
    {
        if ( this->mShaderTable[i].shaderKeyInfo.IsEqual( shaderKey ) )
        {
            // shaderKeyが既にバイナリ化 されている場合
            findCache = i;
            break;
        }
    }
    return findCache;
}*/

} // ShaderCodeGeneratorGeneric
} // EffectMaker
