﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Windows.Forms;
using EffectMaker.Foundation.Primitives;
using EffectMaker.UIControls.Extensions;
using EffectMaker.UIControls.Specifics.TableEditor;

namespace EffectMaker.Application.TestDialog
{
    /// <summary>
    /// The table editor data grid test.
    /// </summary>
    public partial class TakeuchiTestDialog : Form
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TakeuchiTestDialog"/> class.
        /// </summary>
        public TakeuchiTestDialog()
        {
            this.InitializeComponent();
            this.curveEditor1.NormalizeAt = 180.0f;
            this.curveEditor1.LabelPrefix = string.Empty;
            this.curveEditor1.LabelDigit = 0;
            this.curveEditor1.MaxLimit = 180;
            this.curveEditor1.MinLimit = -180;
        }

        /// <summary>
        /// The on size changed.
        /// </summary>
        /// <param name="e">
        /// The e.
        /// </param>
        protected override void OnSizeChanged(EventArgs e)
        {
            this.curveEditor1.SuspendDrawing();
            this.curveEditor1.Visible = false;
            this.curveEditor1.Size = this.ClientSize;
            this.curveEditor1.Visible = true;
            this.curveEditor1.ResumeDrawing();
            base.OnSizeChanged(e);
        }
    }
}
