echo off

set ConfigurationName=%1
set SolutionDir=%2
set TargetDir=%3

set SigloRoot=%SolutionDir%..\..\..\..\..\..\
set Outputs=%TargetDir%..\..\..\..\..\..\

set ToolsRoot=%SigloRoot%Tools\

set EFFECT_COMBINER_DLL_DIR=%ToolsRoot%Graphics\EffectCombinerEditor\
set EFFECT_FE1UPDATER_DIR=%ToolsRoot%Graphics\EffectMaker\FE1Updater\
set EFFECT_CE2UPDATER_DIR=%ToolsRoot%Graphics\EffectMaker\CE2Updater\

set LogDst=%Outputs%x86\Tools\Graphics\EffectMaker\Application\%ConfigurationName%\PreBuild.log

echo Executing PreBuild.bat...
echo The output is redirected to %LogDst%

rem ===========================================================================
rem DO NOT use "set SOME_VAR=%ANOTHER_VAR%some_string" after this, it will not
rem work. Please set variables before this line.
rem ===========================================================================
rem Redirect all the output to PreBuild.log
setlocal enabledelayedexpansion
(

rem for DockPanel -----------------
@rem xcopy /f /y %SigloRoot%Documents\Licenses\DockPanelSuite_2_14_0 "%TargetDir%DockPanelSuite\"
@rem CZXt@C NintendoSDK\Documents\Licenses\DockPanelSuite_2_14_0\license.txt ɔzu

rem for Resources -----------------
call %~dp0\CopyResourceFiles.bat %SolutionDir% %TargetDir% 

rem for shaders -----------------
@rem if not exist "%TargetDir%Converter\shader" mkdir "%TargetDir%Converter\shader"

@rem if not exist "%TargetDir%Converter\shader\GLES2" mkdir "%TargetDir%Converter\shader\GLES2"
xcopy /f /y "%SolutionDir%Shaders\GLES2\eft_Particle.fsh"                     "%TargetDir%Converter\shader\GLES2\"
xcopy /f /y "%SolutionDir%Shaders\GLES2\eft_Particle.vsh"                     "%TargetDir%Converter\shader\GLES2\"
xcopy /f /y "%SolutionDir%Shaders\GLES2\eft_ParticleDeclaration.fsh"          "%TargetDir%Converter\shader\GLES2\"
xcopy /f /y "%SolutionDir%Shaders\GLES2\eft_ParticleDeclaration.glsl"         "%TargetDir%Converter\shader\GLES2\"
xcopy /f /y "%SolutionDir%Shaders\GLES2\eft_ParticleDeclaration.vsh"          "%TargetDir%Converter\shader\GLES2\"
xcopy /f /y "%SolutionDir%Shaders\GLES2\eft_ParticleDeclaration_Device.glsl"  "%TargetDir%Converter\shader\GLES2\"
xcopy /f /y "%SolutionDir%Shaders\GLES2\eft_ParticleDeclaration_Windows.glsl" "%TargetDir%Converter\shader\GLES2\"
xcopy /f /y "%SolutionDir%Shaders\GLES2\eft_StreamOut.vsh"                    "%TargetDir%Converter\shader\GLES2\"

xcopy /f /y "%SolutionDir%Shaders\eft_Particle.fsh"                     "%TargetDir%Converter\shader\"
xcopy /f /y "%SolutionDir%Shaders\eft_Particle.vsh"                     "%TargetDir%Converter\shader\"
xcopy /f /y "%SolutionDir%Shaders\eft_ParticleDeclaration.fsh"          "%TargetDir%Converter\shader\"
xcopy /f /y "%SolutionDir%Shaders\eft_ParticleDeclaration.glsl"         "%TargetDir%Converter\shader\"
xcopy /f /y "%SolutionDir%Shaders\eft_ParticleDeclaration.vsh"          "%TargetDir%Converter\shader\"
xcopy /f /y "%SolutionDir%Shaders\eft_ParticleDeclaration_Cafe.glsl"    "%TargetDir%Converter\shader\"
xcopy /f /y "%SolutionDir%Shaders\eft_ParticleDeclaration_Generic.glsl" "%TargetDir%Converter\shader\"
xcopy /f /y "%SolutionDir%Shaders\eft_StreamOut.vsh"                    "%TargetDir%Converter\shader\"
xcopy /f /y "%SolutionDir%Shaders\eft_StreamOutDeclaration.vsh"         "%TargetDir%Converter\shader\"
xcopy /f /y "%SolutionDir%Shaders\vfx_ParticleDeclaration_Cafe.glsl"    "%TargetDir%Converter\shader\"
xcopy /f /y "%SolutionDir%Shaders\vfx_ParticleDeclaration_Generic.glsl" "%TargetDir%Converter\shader\"
xcopy /f /y "%SolutionDir%Shaders\vfx_ParticleDeclaration_NX.glsl"      "%TargetDir%Converter\shader\"
xcopy /f /y "%SolutionDir%Shaders\vfx_ParticleDeclaration_NXVk.glsl"    "%TargetDir%Converter\shader\"

rem for specs -----------------
@rem if not exist "%TargetDir%Specs" mkdir "%TargetDir%Specs"
xcopy /f /y "%SolutionDir%Specs\SpecGeneric.def"      "%TargetDir%Specs\"
xcopy /f /y "%SolutionDir%Specs\SpecGenericVfx.def"   "%TargetDir%Specs\"
xcopy /f /y "%SolutionDir%Specs\SpecGenericVfx32.def" "%TargetDir%Specs\"
xcopy /f /y "%SolutionDir%Specs\SpecGLES2.def"        "%TargetDir%Specs\"
xcopy /f /y "%SolutionDir%Specs\SpecNX.def"           "%TargetDir%Specs\"
xcopy /f /y "%SolutionDir%Specs\SpecNX32.def"         "%TargetDir%Specs\"
xcopy /f /y "%SolutionDir%Specs\SpecNXVk.def"         "%TargetDir%Specs\"

rem for VfxFileFilter -----------------
@rem if not exist "%TargetDir%VfxFileFilter" mkdir "%TargetDir%VfxFileFilter"
xcopy /f /y "%SolutionDir%VfxFileFilter\VfxConvertFmdb.bat" "%TargetDir%VfxFileFilter\"
xcopy /f /y "%SolutionDir%VfxFileFilter\VfxConvertFmdb.py"  "%TargetDir%VfxFileFilter\"

rem Copy the DLL version binary convert utils library -----------------
xcopy /f /y "%ToolsRoot%Graphics\3dTools\3dBinaryConverter.dll" "%TargetDir%"

rem for FE1 updater -----------------
@rem if not exist "%TargetDir%FE1Updater" mkdir "%TargetDir%FE1Updater"
xcopy /f /y "%EFFECT_FE1UPDATER_DIR%FE1Updater.exe"         "%TargetDir%FE1Updater\"
xcopy /f /y "%EFFECT_FE1UPDATER_DIR%NWCore.dll"             "%TargetDir%FE1Updater\"
xcopy /f /y "%EFFECT_FE1UPDATER_DIR%ToolDevelopmentKit.dll" "%TargetDir%FE1Updater\"

rem for CE2 updater -----------------
@rem if not exist "%TargetDir%CE2Updater" mkdir "%TargetDir%CE2Updater"
xcopy /f /y "%EFFECT_CE2UPDATER_DIR%CE2Updater.exe"         "%TargetDir%CE2Updater\"
xcopy /f /y "%EFFECT_CE2UPDATER_DIR%NWCore.dll"             "%TargetDir%CE2Updater\"
xcopy /f /y "%EFFECT_CE2UPDATER_DIR%ToolDevelopmentKit.dll" "%TargetDir%CE2Updater\"

rem Copy the effect combiner editor libraries -----------------
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%Blocks.Core.dll"                          "%TargetDir%"
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%Communication.Contracts.dll"              "%TargetDir%"
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%Communication.Core.dll"                   "%TargetDir%"
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%EffectCombiner.Core.dll"                  "%TargetDir%"
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%EffectCombiner.Data.dll"                  "%TargetDir%"
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%EffectCombiner.Generator.dll"             "%TargetDir%"
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%EffectCombiner.Primitives.Generation.dll" "%TargetDir%"
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%EffectDefinitions.dll"                    "%TargetDir%"
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%Renderer2D.Core.dll"                      "%TargetDir%"
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%ShaderGenerator.Core.dll"                 "%TargetDir%"
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%ShaderGenerator.GLSL.dll"                 "%TargetDir%"
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%ShaderTyping.dll"                         "%TargetDir%"
xcopy /f /y "%EFFECT_COMBINER_DLL_DIR%Workflow.Core.dll"                        "%TargetDir%"

) > "%LogDst%"
rem Redirect all the output to PreBuild.log

echo PreBuild.bat is executed successfully.
