﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.BusinessLogic.ProjectConfig;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Specifics;

namespace EffectMaker.Application
{
    /// <summary>
    /// オプションダイアログ関連のユーティリティを集約します。
    /// </summary>
    public static class OptionUtil
    {
        /// <summary>
        /// オプション編集中の一時的な変更を記憶するためのインスタンスです。
        /// </summary>
        public static EffectMakerProjectConfig TempConfig { get; set; }

        /// <summary>
        /// プロジェクトコンフィグの読み直しがあったことを記録します。
        /// </summary>
        public static bool IsNeedReloadProjectConfig { get; set; }

        /// <summary>
        /// カスタムシェーダの読み直しがあったことを記録します。
        /// </summary>
        public static bool IsNeedReloadCustomShader { get; set; }

        /// <summary>
        /// カスタムアクションの読み直しがあったことを記録します。
        /// </summary>
        public static bool IsNeedReloadCustomAction { get; set; }

        /// <summary>
        /// エミッタ拡張パラメータの読み直しがあったことを記録します。
        /// </summary>
        public static bool IsNeedReloadEmitterExtParams { get; set; }

        /// <summary>
        /// テキストボックスのパスが存在していないものを指していたらピンク背景にします。
        /// </summary>
        /// <param name="s">テキストボックス</param>
        /// <param name="e">イベント引数(使用しません)</param>
        public static void OnCheckFilePathExisting(object s, EventArgs e)
        {
            var textBox = s as UITextBox;
            if (textBox == null)
            {
                return;
            }

            string text = textBox.Text;

            // UIFilePathTextBoxだった場合は、FilePathをチェックする.
            var filePathBox = s as UIFilePathTextBox;
            if (filePathBox != null)
            {
                text = filePathBox.FilePath;
            }

            if (!string.IsNullOrEmpty(text) && !File.Exists(text) && !Directory.Exists(text))
            {
                textBox.BackColor = Color.Pink;
            }
            else
            {
                textBox.BackColor = Color.White;
            }
        }

        /// <summary>
        /// コメント用ラベルの共通設定を行います。
        /// </summary>
        /// <param name="label">
        /// The label.
        /// </param>
        public static void SetCommentLabelState(UIBorderedLabel label)
        {
            label.BackColor = Color.FromArgb(240, 240, 255);
            label.AutoSize = false;
            label.Width = 484;
            label.Anchor = AnchorStyles.Left | AnchorStyles.Right | AnchorStyles.Top;
        }

        /// <summary>
        /// ファイルイベントのマージを行います。
        /// ユーザー設定が優先して適用されます。
        /// ユーザー設定が空の場合にプロジェクト設定が適用されます。
        /// </summary>
        public static void MergeFileEvent()
        {
            FileEventProjectConfig options = OptionStore.RuntimeOptions.FileEventMerge;
            FileEventProjectConfig project = OptionStore.ProjectConfig.FileEventProject;
            FileEventOptions user = OptionStore.RootOptions.FileEvent;

            options.PreSaveCommandFilePath = user.PreSaveCommandFilePath;
            options.PostSaveCommandFilePath = user.PostSaveCommandFilePath;
            options.PreDeleteCommandFilePath = user.PreDeleteCommandFilePath;
            options.PostDeleteCommandFilePath = user.PostDeleteCommandFilePath;
            options.PreOpenCommandFilePath = user.PreOpenCommandFilePath;

            if (String.IsNullOrEmpty(user.PreSaveCommandFilePath))
            {
                options.PreSaveCommandFilePath = project.PreSaveCommandFilePath;
            }
            if (String.IsNullOrEmpty(user.PostSaveCommandFilePath))
            {
                options.PostSaveCommandFilePath = project.PostSaveCommandFilePath;
            }
            if (String.IsNullOrEmpty(user.PreDeleteCommandFilePath))
            {
                options.PreDeleteCommandFilePath = project.PreDeleteCommandFilePath;
            }
            if (String.IsNullOrEmpty(user.PostDeleteCommandFilePath))
            {
                options.PostDeleteCommandFilePath = project.PostDeleteCommandFilePath;
            }
            if (String.IsNullOrEmpty(user.PreOpenCommandFilePath))
            {
                options.PreOpenCommandFilePath = project.PreOpenCommandFilePath;
            }
        }
    }
}
