﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Foundation.IO;

namespace EffectMaker.EffectMakerBridge
{
    /// <summary>
    /// コマンドパラメータのベースクラスです。
    /// </summary>
    public class CommandLineParamsBase
    {
        /// <summary>
        /// ローカライズしたオプションの説明を取得します。
        /// </summary>
        /// <param name="description">Descriptionプロパティの値</param>
        /// <param name="valueName">引数名またはオプション名</param>
        /// <returns>ローカライズされたコマンドラインオプションの説明を返します。</returns>
        public static string LocalizeDescription(string description, string valueName)
        {
            string result = Properties.Resources.ResourceManager.GetString(description, Properties.Resources.Culture);
            System.Diagnostics.Debug.Assert(result != null, "コマンドオプションの Description が null");

            return result;
        }
    }

    /// <summary>
    /// コマンドラインパラメータです。
    /// </summary>
    public class CommandLineParams : CommandLineParamsBase
    {
        /// <summary>
        /// load-filesサブコマンドパラメータを取得または設定します。
        /// </summary>
        [CommandLineSubCommand("load-files", Description = "ConsoleDescLoadFiles", DescriptionConverterName = "LocalizeDescription")]
        public LoadFilesSubParams LoadFiles { get; set; }
    }

    /// <summary>
    /// load-filesサブコマンドパラメータです。
    /// </summary>
    public class LoadFilesSubParams : CommandLineParamsBase
    {
        /// <summary>
        /// 位置引数（オプションではない、名前のない「引数」、ToolFoundation 参照）を取得または設定します。
        /// </summary>
        [CommandLineValues(CountMin = 1, ValueName = "loadFilePaths", Description = "ConsoleDescLoadFilePaths", DescriptionConverterName = "LocalizeDescription")]
        public string[] Paths { get; set; }
    }
}
