﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.Application.CommandLine
{
    /// <summary>
    /// コマンドライン処理を行うインターフェースです。
    /// </summary>
    public abstract class CommandLineProcessorBase
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="workingData">作業データ</param>
        public CommandLineProcessorBase(CommandLineWorkingData workingData)
        {
            this.WorkingData = workingData;
        }

        /// <summary>
        /// 作業データを取得または設定します。
        /// </summary>
        protected CommandLineWorkingData WorkingData { get; private set; }

        /// <summary>
        /// エラー報告を取得します。
        /// </summary>
        public abstract string ErrorReport { get; }

        /// <summary>
        /// 設定処理を行います。
        /// </summary>
        /// <returns>処理が正常に完了したときtrue, それ以外はfalseを返します。</returns>
        public abstract bool Setup();

        /// <summary>
        /// コマンドライン処理を行います。
        /// </summary>
        /// <returns>処理が正常に完了したときtrue, それ以外はfalseを返します。</returns>
        public abstract bool Process();

        /// <summary>
        /// 書き換えた設定などを復元します。
        /// </summary>
        public abstract void Cleanup();
    }
}
