﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class ModelAutoMoveBinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>A flag to prevent the static constructor being called more than once.</summary>
        private static bool isStaticConstructorCalled = false;

        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static ModelAutoMoveBinaryConversionInfo()
        {
            if (isStaticConstructorCalled == true)
            {
                return;
            }

            isStaticConstructorCalled = true;

            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var modelAutoMoveUserBinary = new BinaryStructDefinition(typeof(ModelAutoMoveUserData)) { HasBinaryHeader = false };

            // Output : moveType
            // Inputs : MoveType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelAutoMoveUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("MoveType", new Guid("40e44ebf-b805-4b77-b052-0c8ea00550fe"))
            );

            // Output : radiusXZ
            // Inputs : RadiusXZ
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelAutoMoveUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RadiusXZ", new Guid("d861c06c-f647-48bf-9cd2-468adb53cdb3"))
            );

            // Output : speedXZ
            // Inputs : SpeedXZ
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelAutoMoveUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("SpeedXZ", new Guid("f792e225-b8fd-4ab5-842f-214154d3edcf"))
            );

            // Output : distance
            // Inputs : MoveDistance
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelAutoMoveUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("MoveDistance", new Guid("0d22d6c8-d1ab-4545-9796-4ae6c269584f"))
            );

            // Output : moveSpeed
            // Inputs : MoveSpeed
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelAutoMoveUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("MoveSpeed", new Guid("b312fb17-ae23-416e-a0d2-5bf42b43b10c"))
            );

            // Output : amplitudeY
            // Inputs : AmplitudeY
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelAutoMoveUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AmplitudeY", new Guid("6f615bc9-b669-42e1-99ed-41a8f0cd3472"))
            );

            // Output : speedY
            // Inputs : SpeedY
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelAutoMoveUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("SpeedY", new Guid("a6a65de9-3ee4-4f54-a095-3ead5df7b7f7"))
            );

            // Output : rollZ
            // Inputs : RollZ
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelAutoMoveUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RollZ", new Guid("a727438a-c5a0-41ed-9a44-b7e69d25ba1a"))
            );

            // Output : straightDirection
            // Inputs : StraightDirection
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelAutoMoveUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("StraightDirection", new Guid("c086ddc0-3f7c-4c50-b04e-e021f357aefb"))
            );

            // Output : straightAngle
            // Inputs : StraightAngle
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelAutoMoveUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("StraightAngle", new Guid("4ad7a2f6-a068-4637-9c67-bdff7fb6dca6"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = modelAutoMoveUserBinary;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private ModelAutoMoveBinaryConversionInfo(DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }
    }
}
