::=============================================================================
::  EffectMaker2 で CombinerEditor 連携を行うための DLL セットアップ用バッチ
::  2016.02.15-
::  ※事前に "EffectCombinerEditor" と "EffectMaker の Release 版" がビルドされていることが条件です。
::=============================================================================
@echo off

echo =============================================================================
echo Copy DLLs for EffectCombinerEditor to $(NintendoSdkRoot)/Tools/Graphics/EffectMaker.
echo =============================================================================

set CURRENT_DIR=%~dp0
set NINTENDO_SDK_ROOT=%CURRENT_DIR%..\..\..\..\..\..\
set COMBINER_EDITOR_DIR=%NINTENDO_SDK_ROOT%Tools\Graphics\EffectCombinerEditor\
set EFFECT_MAKER_OUTPUTS=%NINTENDO_SDK_ROOT%Programs\NintendoWare\Outputs\x86\Tools\Graphics\EffectMaker\Application\Release\
set EFFECT_MAKER_DIR=%NINTENDO_SDK_ROOT%Tools\Graphics\EffectMaker\

::=============================================================================
::  EffectCombinerEditor からコピー
::=============================================================================
xcopy /Y "%COMBINER_EDITOR_DIR%Blocks.Core.dll" "%EFFECT_MAKER_DIR%"
xcopy /Y "%COMBINER_EDITOR_DIR%Communication.Contracts.dll" "%EFFECT_MAKER_DIR%"
xcopy /Y "%COMBINER_EDITOR_DIR%Communication.Core.dll" "%EFFECT_MAKER_DIR%"
xcopy /Y "%COMBINER_EDITOR_DIR%EffectCombiner.Core.dll" "%EFFECT_MAKER_DIR%"
xcopy /Y "%COMBINER_EDITOR_DIR%EffectCombiner.Data.dll" "%EFFECT_MAKER_DIR%"
xcopy /Y "%COMBINER_EDITOR_DIR%EffectCombiner.Generator.dll" "%EFFECT_MAKER_DIR%"
xcopy /Y "%COMBINER_EDITOR_DIR%EffectCombiner.Primitives.Generation.dll" "%EFFECT_MAKER_DIR%"
xcopy /Y "%COMBINER_EDITOR_DIR%EffectDefinitions.dll" "%EFFECT_MAKER_DIR%"
xcopy /Y "%COMBINER_EDITOR_DIR%ShaderGenerator.Core.dll" "%EFFECT_MAKER_DIR%"
xcopy /Y "%COMBINER_EDITOR_DIR%ShaderGenerator.GLSL.dll" "%EFFECT_MAKER_DIR%"
xcopy /Y "%COMBINER_EDITOR_DIR%ShaderTyping.dll" "%EFFECT_MAKER_DIR%"
xcopy /Y "%COMBINER_EDITOR_DIR%Workflow.Core.dll" "%EFFECT_MAKER_DIR%"

::=============================================================================
::  EffectMaker からコピー
::=============================================================================
xcopy /Y "%EFFECT_MAKER_OUTPUTS%EffectMaker.EffectCombinerBridge.dll" "%EFFECT_MAKER_DIR%"

pause
@echo on
