﻿#define LINEAR_STEP( minValue, maxValue, x ) ( clamp( (x), (minValue), (maxValue) ) - (minValue) ) / ( (maxValue) - (minValue) )

/// <tag name="Math">
///  <func id="GetLinearStepF4"/>
/// </tag>
/// <func id="GetLinearStepF4" name="GetLinearStepF4">
///  <in name="minValue" type="vec4" />
///  <in name="maxValue" type="vec4" />
///  <in name="x" type="vec4" />
///  <return type="vec4"/>
///  <description>[非推奨]線形Step処理を行います</description>
/// </func>
/// <block guid="{E39119E8-44E6-4033-9329-FBEE1F7BDD5B}" displayname="[deprecated]LinearStepF4">
///  <func id="GetLinearStepF4"/>
///  <in displayname="min" type="vec4" target="minValue"/>
///  <in displayname="max" type="vec4" target="maxValue"/>
///  <in displayname="x" type="vec4" target="x"/>
///  <out displayname="return" type="vec4" target="return"/>
/// </block>
vec4 GetLinearStepF4( vec4 minValue, vec4 maxValue, vec4 x )
{
  vec4 v;
  v.x = LINEAR_STEP( minValue.x, maxValue.x, x.x );
  v.y = LINEAR_STEP( minValue.y, maxValue.y, x.y );
  v.z = LINEAR_STEP( minValue.z, maxValue.z, x.z );
  v.w = LINEAR_STEP( minValue.w, maxValue.w, x.w );
  return v;
}


/// <tag name="Math">
///  <func id="GetLinearStepF3"/>
/// </tag>
/// <func id="GetLinearStepF3" name="GetLinearStepF3">
///  <in name="minValue" type="vec3" />
///  <in name="maxValue" type="vec3" />
///  <in name="x" type="vec3" />
///  <return type="vec3"/>
///  <description>[非推奨]線形Step処理を行います</description>
/// </func>
/// <block guid="{29764B10-5377-4F5F-A4D3-5AA21157094A}" displayname="[deprecated]LinearStepF3">
///  <func id="GetLinearStepF3"/>
///  <in displayname="min" type="vec3" target="minValue"/>
///  <in displayname="max" type="vec3" target="maxValue"/>
///  <in displayname="x" type="vec3" target="x"/>
///  <out displayname="return" type="vec3" target="return"/>
/// </block>
vec3 GetLinearStepF3( vec3 minValue, vec3 maxValue, vec3 x )
{
  vec3 v;
  v.x = LINEAR_STEP( minValue.x, maxValue.x, x.x );
  v.y = LINEAR_STEP( minValue.y, maxValue.y, x.y );
  v.z = LINEAR_STEP( minValue.z, maxValue.z, x.z );
  return v;
}


/// <tag name="Math">
///  <func id="GetLinearStepF2"/>
/// </tag>
/// <func id="GetLinearStepF2" name="GetLinearStepF2">
///  <in name="minValue" type="vec2" />
///  <in name="maxValue" type="vec2" />
///  <in name="x" type="vec2" />
///  <return type="vec2"/>
///  <description>[非推奨]線形Step処理を行います</description>
/// </func>
/// <block guid="{8AEDC3C1-C136-4368-B14E-502D85ABB3A5}" displayname="[deprecated]LinearStepF2">
///  <func id="GetLinearStepF2"/>
///  <in displayname="min" type="vec2" target="minValue"/>
///  <in displayname="max" type="vec2" target="maxValue"/>
///  <in displayname="x" type="vec2" target="x"/>
///  <out displayname="return" type="vec2" target="return"/>
/// </block>
vec2 GetLinearStepF2( vec2 minValue, vec2 maxValue, vec2 x )
{
  vec2 v;
  v.x = LINEAR_STEP( minValue.x, maxValue.x, x.x );
  v.y = LINEAR_STEP( minValue.y, maxValue.y, x.y );
  return v;
}


/// <tag name="Math">
///  <func id="GetLinearStepF"/>
/// </tag>
/// <func id="GetLinearStepF" name="GetLinearStepF">
///  <in name="minValue" type="float" />
///  <in name="maxValue" type="float" />
///  <in name="x" type="float" />
///  <return type="float"/>
///  <description>[非推奨]線形Step処理を行います</description>
/// </func>
/// <block guid="{02D09A4C-7FBF-4003-933B-A98C5E6E54BE}" displayname="[deprecated]LinearStepF">
///  <func id="GetLinearStepF"/>
///  <in displayname="min" type="float" target="minValue"/>
///  <in displayname="max" type="float" target="maxValue"/>
///  <in displayname="x" type="float" target="x"/>
///  <out displayname="return" type="float" target="return"/>
/// </block>
float GetLinearStepF( float minValue, float maxValue, float x )
{
  return LINEAR_STEP( minValue, maxValue, x );
}


/// <tag name="Math">
///  <func id="MinusF4"/>
/// </tag>
/// <func id="MinusF4" name="MinusF4">
///  <in name="value" type="vec4"/>
///  <return type="vec4"/>
///  <description>[非推奨]入力を符号反転（vec4）</description>
/// </func>
/// <block guid="{48954685-4DFD-4F97-95E6-160A94754A9F}" displayname="[deprecated]MinusF4">
///  <func id="MinusF4"/>
///  <in displayname="vec4" type="vec4" target="value" />
///  <out displayname="-vec4" type="vec4" target="return"/>
/// </block>
vec4 MinusF4( vec4 value )
{
  return -value;
}


/// <tag name="Math">
///  <func id="MinusF3"/>
/// </tag>
/// <func id="MinusF3" name="MinusF3">
///  <in name="value" type="vec3"/>
///  <return type="vec3"/>
///  <description>[非推奨]入力を符号反転（vec3）</description>
/// </func>
/// <block guid="{48954685-4DFD-4F96-85E5-160A94754A9F}" displayname="[deprecated]MinusF3">
///  <func id="MinusF3"/>
///  <in displayname="vec3" type="vec3" target="value" />
///  <out displayname="-vec3" type="vec3" target="return"/>
/// </block>
vec3 MinusF3( vec3 value )
{
  return -value;
}


/// <tag name="Math">
///  <func id="MinusF2"/>
/// </tag>
/// <func id="MinusF2" name="MinusF2">
///  <in name="value" type="vec2"/>
///  <return type="vec2"/>
///  <description>[非推奨]入力を符号反転（vec2）</description>
/// </func>
/// <block guid="{48943685-4DFD-4e96-85E5-160A94754A9F}" displayname="[deprecated]MinusF2">
///  <func id="MinusF2"/>
///  <in displayname="vec2" type="vec2" target="value" />
///  <out displayname="-vec2" type="vec2" target="return"/>
/// </block>
vec2 MinusF2( vec2 value )
{
  return -value;
}


/// <tag name="Math">
///  <func id="MinusF"/>
/// </tag>
/// <func id="MinusF" name="MinusF">
///  <in name="value" type="float"/>
///  <return type="float"/>
///  <description>[非推奨]入力を符号反転（float）</description>
/// </func>
/// <block guid="{48943685-4DFD-4e96-85E5-150A93754A9F}" displayname="[deprecated]MinusF">
///  <func id="MinusF"/>
///  <in displayname="x" type="float" target="value" />
///  <out displayname="-x" type="float" target="return"/>
/// </block>
float MinusF( float value )
{
  return -value;
}


/// <tag name="Math">
///  <func id="InverseF4"/>
/// </tag>
/// <func id="InverseF4" name="InverseF4">
///  <in name="value" type="vec4"/>
///  <return type="vec4"/>
///  <description>[非推奨]逆数で構成される vec4 を出力</description>
/// </func>
/// <block guid="{48953707-4DFD-4e99-85E5-151A93754A9F}" displayname="[deprecated]InverseF4">
///  <func id="InverseF4"/>
///  <in displayname="vec4" type="vec4" target="value" />
///  <out displayname="1/vec4" type="vec4" target="return"/>
/// </block>
vec4 InverseF4( vec4 value )
{
  return vec4( 1.0/value.x, 1.0/value.y, 1.0/value.z, 1.0/value.w );
}


/// <tag name="Math">
///  <func id="InverseF3"/>
/// </tag>
/// <func id="InverseF3" name="InverseF3">
///  <in name="value" type="vec3"/>
///  <return type="vec3"/>
///  <description>[非推奨]逆数で構成される vec3 を出力</description>
/// </func>
/// <block guid="{48943797-4DFD-4e98-85E5-151A93754A9F}" displayname="[deprecated]InverseF3">
///  <func id="InverseF3"/>
///  <in displayname="vec3" type="vec3" target="value" />
///  <out displayname="1/vec3" type="vec3" target="return"/>
/// </block>
vec3 InverseF3( vec3 value )
{
  // 1/Xを計算
  return vec3( 1.0/value.x, 1.0/value.y, 1.0/value.z );
}


/// <tag name="Math">
///  <func id="InverseF2"/>
/// </tag>
/// <func id="InverseF2" name="InverseF2">
///  <in name="value" type="vec2"/>
///  <return type="vec2"/>
///  <description>[非推奨]逆数で構成される vec2 を出力</description>
/// </func>
/// <block guid="{48943796-4DFD-4e97-85E5-151A93754A9F}" displayname="[deprecated]InverseF2">
///  <func id="InverseF2"/>
///  <in displayname="vec2" type="vec2" target="value" />
///  <out displayname="1/vec2" type="vec2" target="return"/>
/// </block>
vec2 InverseF2( vec2 value )
{
  return vec2( 1.0/value.x, 1.0/value.y );
}


/// <tag name="Math">
///  <func id="InverseF"/>
/// </tag>
/// <func id="InverseF" name="InverseF">
///  <in name="value" type="float"/>
///  <return type="float"/>
///  <description>[非推奨]逆数を出力</description>
/// </func>
/// <block guid="{48943685-4DFD-4e97-85E5-150A93754A9F}" displayname="[deprecated]InverseF">
///  <func id="InverseF"/>
///  <in displayname="x" type="float" target="value" />
///  <out displayname="1/x" type="float" target="return"/>
/// </block>
float InverseF( float value )
{
  return (1.0 / value);
}


/// <tag name="Math">
///  <func id="GetNormalize4"/>
/// </tag>
/// <func id="GetNormalize4" name="GetNormalize4">
///  <in name="v" type="vec4" />
///  <return type="vec4"/>
///  <description>[非推奨]ベクトルの正規化（vec4）</description>
/// </func>
/// <block guid="{48943683-4DFC-4e96-85E5-150A93754A9F}" displayname="[deprecated]NormalizeV4">
///  <func id="GetNormalize4"/>
///  <in displayname="vec4" type="vec4" target="v"/>
///  <out displayname="vec4" type="vec4" target="return"/>
/// </block>
vec4 GetNormalize4( vec4 v )
{
  return normalize( v );
}


/// <tag name="Math">
///  <func id="GetNormalize3"/>
/// </tag>
/// <func id="GetNormalize3" name="GetNormalize3">
///  <in name="v" type="vec3" />
///  <return type="vec3"/>
///  <description>[非推奨]ベクトルの正規化（vec3）</description>
/// </func>
/// <block guid="{48943682-4DFC-4e96-85E5-150A93754A9F}" displayname="[deprecated]NormalizeV3">
///  <func id="GetNormalize3"/>
///  <in displayname="vec3" type="vec3" target="v"/>
///  <out displayname="vec3" type="vec3" target="return"/>
/// </block>
vec3 GetNormalize3( vec3 v )
{
  return normalize( v );
}


/// <tag name="Math">
///  <func id="GetNormalize2"/>
/// </tag>
/// <func id="GetNormalize2" name="GetNormalize2">
///  <in name="v" type="vec2" />
///  <return type="vec2"/>
///  <description>[非推奨]ベクトルの正規化（vec2）</description>
/// </func>
/// <block guid="{48943682-4DFC-4e96-85E5-151A93754A9F}" displayname="[deprecated]NormalizeV2">
///  <func id="GetNormalize2"/>
///  <in displayname="vec2" type="vec2" target="v"/>
///  <out displayname="vec2" type="vec2" target="return"/>
/// </block>
vec2 GetNormalize2( vec2 v )
{
  return normalize( v );
}


/// <tag name="Math">
///  <func id="Clamp01F4"/>
/// </tag>
/// <func id="Clamp01F4" name="Clamp01F4">
///  <in name="value" type="vec4"/>
///  <return type="vec4"/>
///  <description>[非推奨][0, 1] の範囲で Clamp（vec4）</description>
/// </func>
/// <block guid="{58943685-4DFD-4e97-88E5-260A94764A9F}" displayname="[deprecated]ClampF4 [0, 1]">
///  <func id="Clamp01F4"/>
///  <in displayname="vec4" type="vec4" target="value" />
///  <out displayname="vec4 [0, 1]" type="vec4" target="return"/>
/// </block>
vec4 Clamp01F4( vec4 value )
{
  return vec4(
   clamp( value.x, 0.0, 1.0 ),
   clamp( value.y, 0.0, 1.0 ),
   clamp( value.z, 0.0, 1.0 ),
   clamp( value.w, 0.0, 1.0 ) );
}


/// <tag name="Math">
///  <func id="Clamp01F3"/>
/// </tag>
/// <func id="Clamp01F3" name="Clamp01F3">
///  <in name="value" type="vec3"/>
///  <return type="vec3"/>
///  <description>[非推奨][0, 1] の範囲で Clamp（vec3）</description>
/// </func>
/// <block guid="{58943685-4DFD-4e97-88E5-251A94754A9F}" displayname="[deprecated]ClampF3 [0, 1]">
///  <func id="Clamp01F3"/>
///  <in displayname="vec3" type="vec3" target="value" />
///  <out displayname="vec3 [0, 1]" type="vec3" target="return"/>
/// </block>
vec3 Clamp01F3( vec3 value )
{
  return vec3(
   clamp( value.x, 0.0, 1.0 ),
   clamp( value.y, 0.0, 1.0 ),
   clamp( value.z, 0.0, 1.0 ) );
}


/// <tag name="Math">
///  <func id="Clamp01F2"/>
/// </tag>
/// <func id="Clamp01F2" name="Clamp01F2">
///  <in name="value" type="vec2"/>
///  <return type="vec2"/>
///  <description>[非推奨][0, 1] の範囲で Clamp（vec2）</description>
/// </func>
/// <block guid="{58943685-4DFD-4e97-88E5-250A93754A9F}" displayname="[deprecated]ClampF2 [0, 1]">
///  <func id="Clamp01F2"/>
///  <in displayname="vec2" type="vec2" target="value" />
///  <out displayname="vec2 [0, 1]" type="vec2" target="return"/>
/// </block>
vec2 Clamp01F2( vec2 value )
{
  return vec2( clamp( value.x, 0.0, 1.0 ), clamp( value.y, 0.0, 1.0 ) );
}


/// <tag name="Math">
///  <func id="Clamp01F"/>
/// </tag>
/// <func id="Clamp01F" name="Clamp01F">
///  <in name="value" type="float"/>
///  <return type="float"/>
///  <description>[非推奨][0, 1] の範囲で Clamp（float）</description>
/// </func>
/// <block guid="{48943685-4DFD-4e97-88E5-150A93754A9F}" displayname="[deprecated]ClampF [0, 1]">
///  <func id="Clamp01F"/>
///  <in displayname="x" type="float" target="value" />
///  <out displayname="x [0, 1]" type="float" target="return"/>
/// </block>
float Clamp01F( float value )
{
  return clamp( value, 0.0, 1.0 );
}


/// <tag name="Math">
///  <func id="FractFF"/>
/// </tag>
/// <func id="FractFF" name="FractFF">
///  <in name="f" type="float"/>
///  <return type="float"/>
///  <description>小数部分を抽出</description>
/// </func>
/// <block guid="{58922679-3DFC-4e94-85E4-150A92743A9F}" displayname="Fract">
///  <func id="FractFF"/>
///  <in displayname="x" type="float" target="f"/>
///  <out displayname="return" type="float" target="return"/>
/// </block>
float FractFF( float f )
{
  return fract( f );
}


/// <tag name="Math">
///  <func id="IntegerFF"/>
/// </tag>
/// <func id="IntegerFF" name="IntegerFF">
///  <in name="f" type="float"/>
///  <return type="float"/>
///  <description>整数部分を抽出</description>
/// </func>
/// <block guid="{58922780-4DFC-4e94-85E4-150A92743A9F}" displayname="Integer">
///  <func id="IntegerFF"/>
///  <in displayname="x" type="float" target="f"/>
///  <out displayname="return" type="float" target="return"/>
/// </block>
float IntegerFF( float f )
{
  return f - fract( f );
}


/// <tag name="Math">
///  <func id="GetReflect3"/>
/// </tag>
/// <func id="GetReflect3" name="GetReflect3">
///  <in name="dir" type="vec3" />
///  <in name="norm" type="vec3" />
///  <return type="vec3"/>
///  <description>入射角 vec3 と法線 norm3 から反射ベクトルを出力</description>
/// </func>
/// <block guid="{48933682-4DFC-4e96-85E5-150A93754A9F}" displayname="Reflect">
///  <func id="GetReflect3"/>
///  <in displayname="vec3" type="vec3" target="dir"/>
///  <in displayname="norm3" type="vec3" target="norm"/>
///  <out displayname="return" type="vec3" target="return"/>
/// </block>
vec3 GetReflect3( vec3 dir, vec3 norm )
{
  return reflect( dir, norm );
}


/// <tag name="Math">
///  <func id="GetReflect3_NoRev"/>
/// </tag>
/// <func id="GetReflect3_NoRev" name="GetReflect3_NoRev">
///  <in name="dir" type="vec3" />
///  <in name="norm" type="vec3" />
///  <return type="vec3"/>
///  <description>反射ベクトルを出力（逆向きの場合0ベクトルを返す）</description>
/// </func>
/// <block guid="{48933683-4DFC-4e96-85E5-150A93754A9F}" displayname="Reflect(Ignore Reverse)">
///  <func id="GetReflect3_NoRev"/>
///  <in displayname="vec3" type="vec3" target="dir"/>
///  <in displayname="norm3" type="vec3" target="norm"/>
///  <out displayname="return" type="vec3" target="return"/>
/// </block>
vec3 GetReflect3_NoRev( vec3 dir, vec3 norm )
{
  // I - 2.0 * dot(N, I) * N
  float d = dot( norm, dir );
  // Ignore reverse side
  if( d < 0 ){ return dir - 2 * d * norm; }
  else{ return vec3( 0, 0, 0 ); }
}


/// <tag name="Math">
///  <func id="GetPI"/>
/// </tag>
/// <func id="GetPI" name="GetPI">
///  <return type="float"/>
///  <description>円周率（3.1415…）を取得します</description>
/// </func>
/// <block guid="{1B760945-2CD6-4CCE-8BA0-C9C2E1689A22}" displayname="PI">
///  <func id="GetPI"/>
///  <out displayname="PI" type="float" target="return"/>
/// </block>
float GetPI()
{
    return M_PI;
}


/// <tag name="Math">
///   <func id="GetDegToRad" />
/// </tag>
/// <func id="GetDegToRad" name="GetDegToRad">
///   <return type="float" />
///   <in name="degree" type="float" />
///   <description>角度からラジアンに変換</description>
/// </func>
/// <block guid="{A2644A4B-C078-4BBE-A39E-B1533ED94262}" displayname="DegToRad">
///   <func id="GetDegToRad"/>
///   <in displayname="degree" type="float" target="degree" />
///   <out displayname="radian" type="float" target="return" />
/// </block>
float GetDegToRad(float degree)
{
  return (degree / 180.0) * M_PI;
}


/// <tag name="Math">
///   <func id="GetRadToDeg" />
/// </tag>
/// <func id="GetRadToDeg" name="GetRadToDeg">
///   <return type="float" />
///   <in name="radian" type="float" />
///   <description>ラジアンから角度に変換</description>
/// </func>
/// <block guid="{55FE765A-460C-4D26-A83C-ACB6C1CAD135}" displayname="RadToDeg">
///   <func id="GetRadToDeg"/>
///   <in displayname="radian" type="float" target="radian" />
///   <out displayname="degree" type="float" target="return" />
/// </block>
float GetRadToDeg(float radian)
{
  return (radian / M_PI) * 180.0;
}


/// <tag name="Math">
///   <func id="GetSinRad" />
/// </tag>
/// <func id="GetSinRad" name="GetSinRad">
///   <return type="float" />
///   <in name="radian" type="float" />
///   <description>Sin 関数（ラジアン）</description>
/// </func>
/// <block guid="{90C899B5-7817-4453-9760-DA78C185FD6F}" displayname="SinRad">
///   <func id="GetSinRad"/>
///   <in displayname="radian" type="float" target="radian" />
///   <out displayname="value" type="float" target="return" />
/// </block>
float GetSinRad(float radian)
{
  return sin(radian);
}


/// <tag name="Math">
///   <func id="GetSinDeg" />
/// </tag>
/// <func id="GetSinDeg" name="GetSinDeg">
///   <return type="float" />
///   <in name="degree" type="float" />
///   <description>Sin 関数（角度）</description>
/// </func>
/// <block guid="{E22B2BD6-079F-41DC-ABC3-A0B73CB8510F}" displayname="SinDeg">
///   <func id="GetSinDeg"/>
///   <in displayname="degree" type="float" target="degree" />
///   <out displayname="value" type="float" target="return" />
/// </block>
float GetSinDeg(float degree)
{
  return sin(GetDegToRad(degree));
}


/// <tag name="Math">
///   <func id="GetCosRad" />
/// </tag>
/// <func id="GetCosRad" name="GetCosRad">
///   <return type="float" />
///   <in name="radian" type="float" />
///   <description>Cos 関数（ラジアン）</description>
/// </func>
/// <block guid="{FBB508F4-5DD1-4D23-AD7D-72559629B398}" displayname="CosRad">
///   <func id="GetCosRad"/>
///   <in displayname="radian" type="float" target="radian" />
///   <out displayname="value" type="float" target="return" />
/// </block>
float GetCosRad(float radian)
{
  return cos(radian);
}


/// <tag name="Math">
///   <func id="GetCosDeg" />
/// </tag>
/// <func id="GetCosDeg" name="GetCosDeg">
///   <return type="float" />
///   <in name="degree" type="float" />
///   <description>Cos 関数（角度）</description>
/// </func>
/// <block guid="{7F732ADF-F386-4ABE-9E9E-6A5877F6B7D1}" displayname="CosDeg">
///   <func id="GetCosDeg"/>
///   <in displayname="degree" type="float" target="degree" />
///   <out displayname="value" type="float" target="return" />
/// </block>
float GetCosDeg(float degree)
{
  return cos(GetDegToRad(degree));
}


/// <tag name="Math">
///   <func id="GetTanRad" />
/// </tag>
/// <func id="GetTanRad" name="GetTanRad">
///   <return type="float" />
///   <in name="radian" type="float" />
///   <description>Tan 関数（ラジアン）</description>
/// </func>
/// <block guid="{DA8BD6D0-BCCA-4D7F-9E81-3D3D7EF7A7BE}" displayname="TanRad">
///   <func id="GetTanRad"/>
///   <in displayname="radian" type="float" target="radian" />
///   <out displayname="value" type="float" target="return" />
/// </block>
float GetTanRad(float radian)
{
  return tan(radian);
}


/// <tag name="Math">
///   <func id="GetTanDeg" />
/// </tag>
/// <func id="GetTanDeg" name="GetTanDeg">
///   <return type="float" />
///   <in name="degree" type="float" />
///   <description>Tan 関数（角度）</description>
/// </func>
/// <block guid="{47B07DFC-8FA6-4178-BF45-C37B734B7BB4}" displayname="TanDeg">
///   <func id="GetTanDeg"/>
///   <in displayname="degree" type="float" target="degree" />
///   <out displayname="value" type="float" target="return" />
/// </block>
float GetTanDeg(float degree)
{
  return tan(GetDegToRad(degree));
}

/// <tag name="Math">
///   <func id="GetViewTransform" />
/// </tag>
/// <func id="GetViewTransform" name="GetViewTransform">
///   <return type="vec4" />
///   <in name="inVec" type="vec4" />
///   <description>ビュー座標系に変換します</description>
/// </func>
/// <block guid="{0F53952E-764D-4B0E-925B-04CAF049E448}" displayname="ViewTransform">
///   <func id="GetViewTransform"/>
///   <in displayname="inVec" type="vec4" target="inVec" />
///   <out displayname="outVec" type="vec4" target="return" />
/// </block>
vec4 GetViewTransform(vec4 inVec)
{
  return inVec * sysViewMatrix;
}


/// <tag name="Math">
///   <func id="GetProjectionTransform" />
/// </tag>
/// <func id="GetProjectionTransform" name="GetProjectionTransform">
///   <return type="vec4" />
///   <in name="inVec" type="vec4" />
///   <description>射影変換を行います</description>
/// </func>
/// <block guid="{797DECCA-7414-4CDF-8949-D182EABAF689}" displayname="ProjectionTransform">
///   <func id="GetProjectionTransform"/>
///   <in displayname="inVec" type="vec4" target="inVec" />
///   <out displayname="outVec" type="vec4" target="return" />
/// </block>
vec4 GetProjectionTransform(vec4 inVec)
{
  return inVec * sysProjectionMatrix;
}
