﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Workflow.Core;

namespace UnitTests
{
    [TestClass]
    public class WorkflowCoreEvents
    {
        [TestMethod]
        public void OutputPlugAddRemove1()
        {
            var outputPlugCount = 0;

            var workflowItem = new WorkflowItem<object>();
            var outputPlug = new OutputPlug<object>();

            workflowItem.OutputPlugAdded += delegate { outputPlugCount++; };
            workflowItem.OutputPlugRemoved += delegate { outputPlugCount--; };

            workflowItem.AddOutputPlug(outputPlug);
            if (outputPlugCount != 1)
                throw new Exception();

            workflowItem.RemoveOutputPlug(outputPlug);
            if (outputPlugCount != 0)
                throw new Exception();

            workflowItem.AddOutputPlug(outputPlug);
            workflowItem.AddOutputPlug(outputPlug);
            if (outputPlugCount != 1)
                throw new Exception();

            workflowItem.RemoveOutputPlug(outputPlug);
            workflowItem.RemoveOutputPlug(outputPlug);
            if (outputPlugCount != 0)
                throw new Exception();
        }

        [TestMethod]
        public void OutputPlugAddRemove2()
        {
            var outputPlugCount = 0;

            var workflowItem = new WorkflowItem<object>();
            var outputPlug = new OutputPlug<object>();

            workflowItem.OutputPlugAdded += delegate { outputPlugCount++; };
            workflowItem.OutputPlugRemoved += delegate { outputPlugCount--; };

            workflowItem.AddOutputPlug(outputPlug);
            workflowItem.RemoveOutputPlug(workflowItem.OutputPlugs[0]);

            if (outputPlugCount != 0)
                throw new Exception();
        }

        [TestMethod]
        public void InputPlugAddRemove1()
        {
            var inputPlugCount = 0;

            var workflowItem = new WorkflowItem<object>();
            var inputPlug = new InputPlug<object>();

            workflowItem.InputPlugAdded += delegate { inputPlugCount++; };
            workflowItem.InputPlugRemoved += delegate { inputPlugCount--; };

            workflowItem.AddInputPlug(inputPlug);
            if (inputPlugCount != 1)
                throw new Exception();

            workflowItem.RemoveInputPlug(inputPlug);
            if (inputPlugCount != 0)
                throw new Exception();

            workflowItem.AddInputPlug(inputPlug);
            workflowItem.AddInputPlug(inputPlug);
            if (inputPlugCount != 1)
                throw new Exception();

            workflowItem.RemoveInputPlug(inputPlug);
            workflowItem.RemoveInputPlug(inputPlug);
            if (inputPlugCount != 0)
                throw new Exception();
        }

        [TestMethod]
        public void InputPlugAddRemove2()
        {
            var inputPlugCount = 0;

            var workflowItem = new WorkflowItem<object>();
            var inputPlug = new InputPlug<object>();

            workflowItem.InputPlugAdded += delegate { inputPlugCount++; };
            workflowItem.InputPlugRemoved += delegate { inputPlugCount--; };

            workflowItem.AddInputPlug(inputPlug);
            workflowItem.RemoveInputPlug(workflowItem.InputPlugs[0]);

            if (inputPlugCount != 0)
                throw new Exception();
        }

        [TestMethod]
        public void WorkflowItemNameChanged()
        {
            string currentName = null;

            var workflowItem = new WorkflowItem<object>();
            workflowItem.NameChanged += delegate { currentName = workflowItem.Name; };

            workflowItem.Name = "A";
            if (currentName != "A")
                throw new Exception();

            workflowItem.Name = "B";
            if (currentName != "B")
                throw new Exception();
        }

        [TestMethod]
        public void WorkflowItemInputInvalidated1()
        {
            var invalidatedCount = 0;

            var workflowItem1 = new ValueWorkflowItem<int>(0);
            workflowItem1.AddOutputPlug(new OutputPlug<int>());

            var workflowItem2 = new WorkflowItem<int>();
            workflowItem2.InputsInvalidated += delegate { invalidatedCount++; };
            workflowItem2.AddInputPlug(new InputPlug<int>());
            workflowItem2.AddInputPlug(new InputPlug<int>());

            if (invalidatedCount != 2)
                throw new Exception();

            ConnectionManager.Connect(workflowItem1.OutputPlugs[0], workflowItem2.InputPlugs[1]);

            workflowItem1.SetValue(51);

            if (invalidatedCount != 4)
                throw new Exception();

            ConnectionManager.Disconnect(workflowItem2.InputPlugs[1]);
            ConnectionManager.Connect(workflowItem1.OutputPlugs[0], workflowItem2.InputPlugs[0]);

            if (invalidatedCount != 6)
                throw new Exception();
        }

        [TestMethod]
        public void WorkflowItemInputInvalidated2()
        {
            var invalidatedCount = 0;

            var workflowItem1 = new ValueWorkflowItem<int>(0);
            workflowItem1.AddOutputPlug(new OutputPlug<int>());

            var workflowItem2 = new WorkflowItem<int>();
            workflowItem2.InputsInvalidated += delegate { invalidatedCount++; };
            var inputPlug = new InputPlug<int>();

            if (invalidatedCount != 0)
                throw new Exception();

            ConnectionManager.Connect(workflowItem1.OutputPlugs[0], inputPlug);

            if (invalidatedCount != 0)
                throw new Exception();

            workflowItem1.SetValue(51);

            if (invalidatedCount != 0)
                throw new Exception();

            workflowItem2.AddInputPlug(inputPlug);

            if (invalidatedCount != 1)
                throw new Exception();

            ConnectionManager.Disconnect(inputPlug);

            if (invalidatedCount != 2)
                throw new Exception();

            ConnectionManager.Connect(workflowItem1.OutputPlugs[0], inputPlug);

            if (invalidatedCount != 3)
                throw new Exception();
        }

        [TestMethod]
        public void OutputPlugValueChanging()
        {
            var oldValue = 0;
            var newValue = 0;

            var workflowItem1 = new ValueWorkflowItem<int>(0);
            workflowItem1.AddOutputPlug(new OutputPlug<int>());

            var workflowItem2 = new TransferWorkflowItem<int>(1);

            workflowItem2.OutputPlugs[0].ValueChanging += (s, e) => { oldValue = e.OldValue; newValue = e.NewValue; };

            ConnectionManager.Connect(workflowItem1.OutputPlugs[0], workflowItem2.InputPlugs[0]);

            if (oldValue != 0 || newValue != 0)
                throw new Exception();

            workflowItem1.SetValue(51);

            if (oldValue != 0 || newValue != 51)
                throw new Exception();

            workflowItem1.SetValue(52);

            if (oldValue != 51 || newValue != 52)
                throw new Exception();

            workflowItem1.SetValue(53);

            if (oldValue != 52 || newValue != 53)
                throw new Exception();
        }

        [TestMethod]
        public void OutputPlugValueChanged()
        {
            var oldValue = 0;
            var newValue = 0;

            var workflowItem1 = new ValueWorkflowItem<int>(0);
            workflowItem1.AddOutputPlug(new OutputPlug<int>());

            var workflowItem2 = new TransferWorkflowItem<int>(1);

            workflowItem2.OutputPlugs[0].ValueChanged += (s, e) => { oldValue = e.OldValue; newValue = e.NewValue; };

            ConnectionManager.Connect(workflowItem1.OutputPlugs[0], workflowItem2.InputPlugs[0]);

            if (oldValue != 0 || newValue != 0)
                throw new Exception();

            workflowItem1.SetValue(51);

            if (oldValue != 0 || newValue != 51)
                throw new Exception();

            workflowItem1.SetValue(52);

            if (oldValue != 51 || newValue != 52)
                throw new Exception();

            workflowItem1.SetValue(53);

            if (oldValue != 52 || newValue != 53)
                throw new Exception();
        }

        [TestMethod]
        public void InputPlugValueChanging()
        {
            var oldValue = 0;
            var newValue = 0;

            var workflowItem1 = new ValueWorkflowItem<int>(0);
            workflowItem1.AddOutputPlug(new OutputPlug<int>());

            var workflowItem2 = new WorkflowItem<int>();
            workflowItem2.AddInputPlug(new InputPlug<int>());

            workflowItem2.InputPlugs[0].ValueChanging += (s, e) => { oldValue = e.OldValue; newValue = e.NewValue; };

            ConnectionManager.Connect(workflowItem1.OutputPlugs[0], workflowItem2.InputPlugs[0]);

            if (oldValue != 0 || newValue != 0)
                throw new Exception();

            workflowItem1.SetValue(51);

            if (oldValue != 0 || newValue != 51)
                throw new Exception();

            workflowItem1.SetValue(52);

            if (oldValue != 51 || newValue != 52)
                throw new Exception();

            workflowItem1.SetValue(53);

            if (oldValue != 52 || newValue != 53)
                throw new Exception();
        }

        [TestMethod]
        public void InputPlugValueChanged()
        {
            var oldValue = 0;
            var newValue = 0;

            var workflowItem1 = new ValueWorkflowItem<int>(0);
            workflowItem1.AddOutputPlug(new OutputPlug<int>());

            var workflowItem2 = new WorkflowItem<int>();
            workflowItem2.AddInputPlug(new InputPlug<int>());

            workflowItem2.InputPlugs[0].ValueChanged += (s, e) => { oldValue = e.OldValue; newValue = e.NewValue; };

            ConnectionManager.Connect(workflowItem1.OutputPlugs[0], workflowItem2.InputPlugs[0]);

            if (oldValue != 0 || newValue != 0)
                throw new Exception();

            workflowItem1.SetValue(51);

            if (oldValue != 0 || newValue != 51)
                throw new Exception();

            workflowItem1.SetValue(52);

            if (oldValue != 51 || newValue != 52)
                throw new Exception();

            workflowItem1.SetValue(53);

            if (oldValue != 52 || newValue != 53)
                throw new Exception();
        }

        [TestMethod]
        public void WorkflowItemChanged()
        {
            WorkflowItem<object> oldWorkflowItem = null;
            WorkflowItem<object> newWorkflowItem = null;

            var workflowItem1 = new WorkflowItem<object>();
            var workflowItem2 = new WorkflowItem<object>();

            var outputPlug = new OutputPlug<object>();
            outputPlug.WorkflowItemChanged += (s, e) => { oldWorkflowItem = e.OldWorkflowItem; newWorkflowItem = e.NewWorkflowItem; };

            if (oldWorkflowItem != null || newWorkflowItem != null)
                throw new Exception();

            workflowItem1.AddOutputPlug(outputPlug);

            if (oldWorkflowItem != null || newWorkflowItem != workflowItem1)
                throw new Exception();

            workflowItem1.RemoveOutputPlug(outputPlug);

            if (oldWorkflowItem != workflowItem1 || newWorkflowItem != null)
                throw new Exception();

            workflowItem2.AddOutputPlug(outputPlug);

            if (oldWorkflowItem != null || newWorkflowItem != workflowItem2)
                throw new Exception();
        }
    }
}
