﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ShaderGenerator.GLSL
{
    public class VariableGenerator
    {
        public VariableGenerator()
        {
            Reset();
        }

        public void Reset()
        {
            seeds.Clear();
        }

        /// <summary>
        /// Generate a variable with a unique name prefixed with functionName and paramName
        /// </summary>
        /// <param name="functionName">Name of the function</param>
        /// <param name="paramName">Name of the parameter (null for a return value)</param>
        /// <param name="type">Type of the parameter</param>
        /// <returns>PlugValue with unique name</returns>
        public Variable GenerateNew(string functionName, string paramName, ShaderTyping.ShaderTypeDefinition type)
        {
            string name = null;

            if (!type.IsVoid)
            {
                string baseName = string.Format("{0}_{1}_", functionName, paramName);

                int seed = 1;
                if (seeds.ContainsKey(baseName))
                {
                    seed = seeds[baseName];
                }
                name = baseName + seed;

                seeds[baseName] = seed + 1;
            }

            return new Variable(type, name);
        }

        /// <summary>
        /// Dictionary to keep track of used names.
        /// Names are made of a base name and an integer suffix.
        /// The key is the base name, the value is the smallest available integer to suffix the base name with.
        /// </summary>
        private Dictionary<string, int> seeds = new Dictionary<string, int>();
    }
}
