﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ShaderTyping;

namespace ShaderGenerator.Core
{
    public static class Extensions
    {
        public static string GetMangling(this FunctionDefinition function)
        {
            var parameters = String.Join("_", function.Parameters.Select<ParameterDefinition, string>(a => a.GetMangling()));
            return String.Format("{0}_{1}_{2}", function.ReturnType, function.Name, parameters);
        }

        public static string GetMangling(this ParameterDefinition parameter)
        {
            string direction = String.Empty;
            switch (parameter.Direction)
            {
                case ParameterDirection.Input: direction = "in"; break;
                case ParameterDirection.Output: direction = "out"; break;
                case ParameterDirection.Reference: direction = "ref"; break;
            }
            return String.Format("{0}_{1}", direction, parameter.Type);
        }
    }
}
