﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Renderer2D.Core;
using SharpDX.Direct2D1;

namespace Renderer2D.Direct2D1
{
    public class D2D1BitmapContainer : IBitmap
    {
        public ISize Size { get; private set; }
        public Bitmap NativeBitmap { get; private set; }

        public D2D1BitmapContainer(Bitmap bitmap)
        {
            if (bitmap == null)
                throw new ArgumentNullException("bitmap");

            NativeBitmap = bitmap;
            Size = new Size(NativeBitmap.PixelSize.Width, NativeBitmap.PixelSize.Height);
        }
    }
}
