﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace Renderer2D.Core
{
    public interface IBrush : IDisposable
    {
    }

    // --------------------------------------------------------------------------

    public interface ISolidColorBrush : IBrush
    {
        IColor Color { get; set; }
    }

    public abstract class SolidColorBrush : ISolidColorBrush
    {
        public IColor Color { get; set; }
        public abstract void Dispose();
    }

    // --------------------------------------------------------------------------

    public interface ILinearGradientBrush : IBrush
    {
        IGradientStop[] GradientStops { get; set; }
        IPoint StartPoint { get; set; }
        IPoint EndPoint { get; set; }
    }

    public abstract class LinearGradientBrush : ILinearGradientBrush
    {
        public IGradientStop[] GradientStops { get; set; }
        public IPoint StartPoint { get; set; }
        public IPoint EndPoint { get; set; }
        public abstract void Dispose();
    }

    // --------------------------------------------------------------------------

    public interface IRadialGradientBrush : IBrush
    {
        IPoint Center { get; set; }
        IPoint GradientOriginOffset { get; set; }
        double RadiusX { get; set; }
        double RadiusY { get; set; }
        IGradientStop[] GradientStops { get; set; }
    }

    public abstract class RadialGradientBrush : IRadialGradientBrush
    {
        public IPoint Center { get; set; }
        public IPoint GradientOriginOffset { get; set; }
        public double RadiusX { get; set; }
        public double RadiusY { get; set; }
        public abstract void Dispose();
        public IGradientStop[] GradientStops { get; set; }
    }

    // --------------------------------------------------------------------------

    public interface IGradientStop
    {
        IColor Color { get; set; }
        double Offset { get; set; }
    }

    public class GradientStop : IGradientStop
    {
        public GradientStop()
        {
        }

        public GradientStop(IColor color, double offset)
        {
            if (color == null)
                throw new ArgumentNullException("color");

            Color = color;
            Offset = offset;
        }

        public IColor Color { get; set; }
        public double Offset { get; set; }

        public override string ToString()
        {
            return string.Format("{0} : {1}", Offset, Color);
        }
    }
}
