﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace TestProject1
{
    [TestClass]
    public class ClearTests
    {
        [TestMethod]
        public void TestClear1()
        {
            var stack = new DummyOperationManager();

            var canUndo = stack.CanUndo;
            var canRedo = stack.CanRedo;

            if (canUndo || canRedo)
                throw new Exception();

            stack.CanRedoChanged += (s, e) => canRedo = stack.CanRedo;
            stack.CanUndoChanged += (s, e) => canUndo = stack.CanUndo;

            if (canUndo || canRedo)
                throw new Exception();

            stack.Add(new DummyOperation("A"));

            if (canUndo == false || canRedo)
                throw new Exception();

            stack.Add(new DummyOperation("B"));

            if (canUndo == false || canRedo)
                throw new Exception();

            if (stack.Undo() == false)
                throw new Exception();

            if (canUndo == false || canRedo == false)
                throw new Exception();

            stack.Clear();

            if (canUndo || canRedo)
                throw new Exception();
        }
    }
}
