﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Globalization;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using OperationManager.Core;
using System.Threading;
using System.Threading.Tasks;

namespace TestProject1
{
    [TestClass]
    public class AddTests
    {
        [TestMethod]
        public void TestAddUndoRedo1()
        {
            var stack = new DummyOperationManager();
            if (stack.Index != 0)
                throw new Exception();
            if (stack.Undo())
                throw new Exception();
            if (stack.Index != 0)
                throw new Exception();
        }

        [TestMethod]
        public void TestAddUndoRedo2()
        {
            var stack = new DummyOperationManager();
            if (stack.Index != 0)
                throw new Exception();
            if (stack.Redo())
                throw new Exception();
            if (stack.Index != 0)
                throw new Exception();
        }

        [TestMethod]
        public void TestAddUndoRedo3()
        {
            var stack = new DummyOperationManager();

            stack.Add(new DummyOperation("A"));

            if (stack.Index != 1)
                throw new Exception();

            if (stack.Undo() == false)
                throw new Exception();
            if (stack.Index != 0)
                throw new Exception();

            if (stack.Undo())
                throw new Exception();
            if (stack.Index != 0)
                throw new Exception();
        }

        [TestMethod]
        public void TestAddUndoRedo4()
        {
            var stack = new DummyOperationManager();

            stack.Add(new DummyOperation("A"));

            if (stack.Index != 1)
                throw new Exception();

            if (stack.Redo())
                throw new Exception();
            if (stack.Index != 1)
                throw new Exception();

            if (stack.Redo())
                throw new Exception();
            if (stack.Index != 1)
                throw new Exception();
        }

        [TestMethod]
        public void TestAddUndoRedo5()
        {
            var stack = new DummyOperationManager();
            var item = new DummyOperation("A");

            stack.Add(item);

            if (stack.Index != 1)
                throw new Exception();

            if (stack.Undo() == false)
                throw new Exception();
            if (stack.Index != 0)
                throw new Exception();

            if (stack.Redo() == false)
                throw new Exception();
            if (stack.Index != 1)
                throw new Exception();

            if (item.UndoCount != 1)
                throw new Exception();
            if (item.RedoCount != 1)
                throw new Exception();
        }

        [TestMethod]
        public void TestAddUndoRedo6()
        {
            var stack = new DummyOperationManager();
            var item = new DummyOperation("A");

            stack.Add(item);

            if (stack.Index != 1)
                throw new Exception();

            if (stack.Redo())
                throw new Exception();
            if (stack.Index != 1)
                throw new Exception();

            if (stack.Undo() == false)
                throw new Exception();
            if (stack.Index != 0)
                throw new Exception();

            if (item.UndoCount != 1)
                throw new Exception();
            if (item.RedoCount != 0)
                throw new Exception();
        }

        [TestMethod]
        public void TestAddUndoRedo7()
        {
            const int maxCapacity = 200;
            const int excess = 10;

            var stack = new DummyOperationManager(maxCapacity);

            var discardedCount = 0;

            stack.OperationsDiscarded += (ss, ee) =>
                {
                    discardedCount += ee.Operations.Length;
                };

            for (var i = 0; i < maxCapacity + excess; i++)
                stack.Add(new DummyOperation(i.ToString(CultureInfo.InvariantCulture)));

            if (discardedCount != excess)
                throw new Exception();

            if (stack.Redo())
                throw new Exception();

            if (stack.Undo() == false)
                throw new Exception();

            if (stack.Index != maxCapacity - 1)
                throw new Exception();
        }


        [TestMethod]
        public void TestAddUndoRedo8()
        {
            var stack = new DummyOperationManager();

            var a = new DummyOperation("A");
            var b = new DummyOperation("B");
            var c = new DummyOperation("C");
            var d = new DummyOperation("D");

            stack.Add(a);
            stack.Add(b);
            stack.Add(c);

            if (stack.Index != 3)
                throw new Exception();

            if (stack.Undo() == false)
                throw new Exception();
            if (stack.Undo() == false)
                throw new Exception();

            stack.Add(d);
            // must contains A and D
            if (stack.Index != 2)
                throw new Exception();

            if (stack.Undo() == false)
                throw new Exception();

            if (stack.Index != 1)
                throw new Exception();

            if (stack.Redo() == false)
                throw new Exception();

            if (stack.Index != 2)
                throw new Exception();

            if (stack.Redo())
                throw new Exception();

            if (stack.Index != 2)
                throw new Exception();

            if (stack.Redo())
                throw new Exception();
        }

        [TestMethod]
        public void TestUnsafeAdd1()
        {
            var stack = new DummyOperationManager();
            var item = new DummyOperation("A");

            stack.Add(item);

            stack.Undo();
            stack.Redo();

            try
            {
                item.Rollback();
                throw new Exception();
            }
            catch
            {
            }

            try
            {
                item.Execute();
                throw new Exception();
            }
            catch
            {
            }
        }
    }
}
