﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using OperationManager.Core;

namespace TestProject1
{
    [TestClass]
    public class AddRangeTests
    {
        [TestMethod]
        public void TestAddRange1()
        {
            const int maxCapacity = 200;
            const int firstAdd = 150;
            const int secondAdd = 70;

            var stack = new DummyOperationManager(maxCapacity);

            var swallowedCount = 0;
            var disbranchedCount = 0;

            stack.OperationsDiscarded += (ss, ee) =>
                {
                    if (ee.Type == OperationDiscardType.Overflowed)
                        swallowedCount += ee.Operations.Length;
                    else if (ee.Type == OperationDiscardType.Disbranched)
                        disbranchedCount += ee.Operations.Length;
                };

            var index = 0;

            stack.AddRange(Enumerable.Range(0, firstAdd).Select(_ => new DummyOperation((index++).ToString())));

            if (swallowedCount != 0 || disbranchedCount != 0)
                throw new Exception();

            stack.AddRange(Enumerable.Range(0, secondAdd).Select(_ => new DummyOperation((index++).ToString())));

            if (swallowedCount != ((firstAdd + secondAdd) - maxCapacity) || disbranchedCount != 0)
                throw new Exception();

            if (stack.Operations.Count() != maxCapacity)
                throw new Exception();
        }

        [TestMethod]
        public void TestAddRange2()
        {
            const int maxCapacity = 200;
            const int firstAdd = 150;
            const int secondAdd = 300;

            var stack = new DummyOperationManager(maxCapacity);

            var swallowedCount = 0;
            var disbranchedCount = 0;

            stack.OperationsDiscarded += (ss, ee) =>
            {
                if (ee.Type == OperationDiscardType.Overflowed)
                    swallowedCount += ee.Operations.Length;
                else if (ee.Type == OperationDiscardType.Disbranched)
                    disbranchedCount += ee.Operations.Length;
            };

            var index = 0;

            stack.AddRange(Enumerable.Range(0, firstAdd).Select(_ => new DummyOperation((index++).ToString())));

            if (swallowedCount != 0 || disbranchedCount != 0)
                throw new Exception();

            stack.AddRange(Enumerable.Range(0, secondAdd).Select(_ => new DummyOperation((index++).ToString())));

            if (swallowedCount != firstAdd + (secondAdd - maxCapacity) || disbranchedCount != 0)
                throw new Exception();

            if (stack.Operations.Count() != maxCapacity)
                throw new Exception();
        }

        [TestMethod]
        public void TestAddRange3()
        {
            const int maxCapacity = 200;
            const int firstAdd = 100;
            const int secondAdd = 50;

            var stack = new DummyOperationManager(maxCapacity);

            var swallowedCount = 0;
            var disbranchedCount = 0;

            stack.OperationsDiscarded += (ss, ee) =>
            {
                if (ee.Type == OperationDiscardType.Overflowed)
                    swallowedCount += ee.Operations.Length;
                else if (ee.Type == OperationDiscardType.Disbranched)
                    disbranchedCount += ee.Operations.Length;
            };

            var index = 0;

            stack.AddRange(Enumerable.Range(0, firstAdd).Select(_ => new DummyOperation((index++).ToString())));

            if (swallowedCount != 0 || disbranchedCount != 0)
                throw new Exception();

            for (var i = 0; i < secondAdd; i++)
                stack.Undo();

            stack.AddRange(Enumerable.Range(0, secondAdd).Select(_ => new DummyOperation((index++).ToString())));

            if (swallowedCount != 0 || disbranchedCount != secondAdd)
                throw new Exception();

            if (stack.Operations.Count() != firstAdd)
                throw new Exception();
        }
    }
}
