﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using EnvironmentReporting;

namespace EnvironmentInformationProvider
{
    class SystemEnvironmentInformationProvider : IInformationProvider
    {
        public string InformationDescription { get { return "UI options"; } }

        public ContextInformation GetInformation()
        {
            var environmentInfo = new ContextInformationContainer();

            environmentInfo.Add("Caret blink time", new DecimalContextInformation(SystemInformation.CaretBlinkTime));
            try { environmentInfo.Add("Caret width", new DecimalContextInformation(SystemInformation.CaretWidth)); }
            catch (NotSupportedException) { environmentInfo.Add("Caret width", new StringContextInformation("Not supported")); }
            environmentInfo.Add("High contrast enabled", new DecimalContextInformation(SystemInformation.HighContrast ? 1 : 0));

            environmentInfo.Add("Active window tracking delay (ms)", new DecimalContextInformation(SystemInformation.ActiveWindowTrackingDelay));
            environmentInfo.Add("Arrange direction", new StringContextInformation(SystemInformation.ArrangeDirection.ToString()));
            environmentInfo.Add("Arrange starting position", new StringContextInformation(SystemInformation.ArrangeStartingPosition.ToString()));

            // Window borders
            environmentInfo.Add("Border 3D size", SystemInformation.Border3DSize.ToInformationContainer());
            environmentInfo.Add("Border multiplier factor", new DecimalContextInformation(SystemInformation.BorderMultiplierFactor));
            environmentInfo.Add("Border size", SystemInformation.BorderSize.ToInformationContainer());
            environmentInfo.Add("Fixed frame border size", SystemInformation.FixedFrameBorderSize.ToInformationContainer());
            environmentInfo.Add("Sizing border width", new DecimalContextInformation(SystemInformation.SizingBorderWidth));

            // Window title bar
            environmentInfo.Add("Caption button size", SystemInformation.CaptionButtonSize.ToInformationContainer());
            environmentInfo.Add("Small caption button size", SystemInformation.SmallCaptionButtonSize.ToInformationContainer());
            environmentInfo.Add("Caption height", new DecimalContextInformation(SystemInformation.CaptionHeight));
            environmentInfo.Add("Tool window caption button size", SystemInformation.ToolWindowCaptionButtonSize.ToInformationContainer());
            environmentInfo.Add("Tool window caption height", new DecimalContextInformation(SystemInformation.ToolWindowCaptionHeight));
            environmentInfo.Add("Title bar gradient enabled", new DecimalContextInformation(SystemInformation.IsTitleBarGradientEnabled ? 1 : 0));

            environmentInfo.Add("Minimum window size", SystemInformation.MinimumWindowSize.ToInformationContainer());
            environmentInfo.Add("Minimum window track size", SystemInformation.MinWindowTrackSize.ToInformationContainer());
            environmentInfo.Add("Maximum window track size", SystemInformation.MaxWindowTrackSize.ToInformationContainer());
            environmentInfo.Add("Minimized window size", SystemInformation.MinimizedWindowSize.ToInformationContainer());
            environmentInfo.Add("Minimized window spacing size", SystemInformation.MinimizedWindowSpacingSize.ToInformationContainer());

            // Focus
            try { environmentInfo.Add("Horizontal focus thickness", new DecimalContextInformation(SystemInformation.HorizontalFocusThickness)); }
            catch (NotSupportedException) { environmentInfo.Add("Horizontal focus thickness", new StringContextInformation("Not supported")); }
            try { environmentInfo.Add("Vertical focus thickness", new DecimalContextInformation(SystemInformation.VerticalFocusThickness)); }
            catch (NotSupportedException) { environmentInfo.Add("Vertical focus thickness", new StringContextInformation("Not supported")); }
            environmentInfo.Add("Horizontal resize border thickness", new DecimalContextInformation(SystemInformation.HorizontalResizeBorderThickness));
            environmentInfo.Add("Vertical resize border thickness", new DecimalContextInformation(SystemInformation.VerticalResizeBorderThickness));

            // Scroll bars
            environmentInfo.Add("Horizontal scroll bar arrow width", new DecimalContextInformation(SystemInformation.HorizontalScrollBarArrowWidth));
            environmentInfo.Add("Horizontal scroll bar height", new DecimalContextInformation(SystemInformation.HorizontalScrollBarHeight));
            environmentInfo.Add("Horizontal scroll bar thumb width", new DecimalContextInformation(SystemInformation.HorizontalScrollBarThumbWidth));
            environmentInfo.Add("Vertical scroll bar arrow height", new DecimalContextInformation(SystemInformation.VerticalScrollBarArrowHeight));
            environmentInfo.Add("Vertical scroll bar width", new DecimalContextInformation(SystemInformation.VerticalScrollBarWidth));
            environmentInfo.Add("Vertical scroll bar thumb height", new DecimalContextInformation(SystemInformation.VerticalScrollBarThumbHeight));

            // Icons related info
            environmentInfo.Add("Icon size", SystemInformation.IconSize.ToInformationContainer());
            environmentInfo.Add("Small icon size", SystemInformation.SmallIconSize.ToInformationContainer());
            environmentInfo.Add("Icon title wrapping enabled", new DecimalContextInformation(SystemInformation.IsIconTitleWrappingEnabled ? 1 : 0));
            environmentInfo.Add("Icon spacing size", SystemInformation.IconSpacingSize.ToInformationContainer());
            environmentInfo.Add("Icon horizontal spacing", new DecimalContextInformation(SystemInformation.IconHorizontalSpacing));
            environmentInfo.Add("Icon vertical spacing", new DecimalContextInformation(SystemInformation.IconVerticalSpacing));

            // Menus
            environmentInfo.Add("Menu font", new StringContextInformation(SystemInformation.MenuFont.ToString()));
            environmentInfo.Add("Menu line height", new DecimalContextInformation(SystemInformation.MenuHeight));
            environmentInfo.Add("Menu button size", SystemInformation.MenuButtonSize.ToInformationContainer());
            environmentInfo.Add("Menu bar button size", SystemInformation.MenuBarButtonSize.ToInformationContainer());
            environmentInfo.Add("Menu check mark size", SystemInformation.MenuCheckSize.ToInformationContainer());
            environmentInfo.Add("Menu access key always underlined", new DecimalContextInformation(SystemInformation.MenuAccessKeysUnderlined ? 1 : 0));
            environmentInfo.Add("Menus right aligned", new DecimalContextInformation(SystemInformation.RightAlignedMenus ? 1 : 0));
            environmentInfo.Add("Popup menu alignment", new StringContextInformation(SystemInformation.PopupMenuAlignment.ToString()));
            environmentInfo.Add("Menu show delay (ms)", new DecimalContextInformation(SystemInformation.MenuShowDelay));
            environmentInfo.Add("Flat menu enabled", new DecimalContextInformation(SystemInformation.IsFlatMenuEnabled ? 1 : 0));
            environmentInfo.Add("Menu animation enabled", new DecimalContextInformation(SystemInformation.IsMenuAnimationEnabled ? 1 : 0));
            environmentInfo.Add("Menu fade enabled", new DecimalContextInformation(SystemInformation.IsMenuFadeEnabled ? 1 : 0));

            // Other UI info
            environmentInfo.Add("Active window tracking enabled", new DecimalContextInformation(SystemInformation.IsActiveWindowTrackingEnabled ? 1 : 0));
            environmentInfo.Add("UI elements hot tracking enabled", new DecimalContextInformation(SystemInformation.IsHotTrackingEnabled ? 1 : 0));
            environmentInfo.Add("UI effects enabled", new DecimalContextInformation(SystemInformation.UIEffectsEnabled ? 1 : 0));
            environmentInfo.Add("Combo box animation enabled", new DecimalContextInformation(SystemInformation.IsComboBoxAnimationEnabled ? 1 : 0));
            environmentInfo.Add("Combo box animation enabled", new DecimalContextInformation(SystemInformation.IsComboBoxAnimationEnabled ? 1 : 0));
            environmentInfo.Add("Minimize/restore animation enabled", new DecimalContextInformation(SystemInformation.IsMinimizeRestoreAnimationEnabled ? 1 : 0));
            environmentInfo.Add("Tool tip animation enabled", new DecimalContextInformation(SystemInformation.IsToolTipAnimationEnabled ? 1 : 0));
            environmentInfo.Add("Drop shadow enabled", new DecimalContextInformation(SystemInformation.IsDropShadowEnabled ? 1 : 0));
            environmentInfo.Add("List box smooth scrolling enabled", new DecimalContextInformation(SystemInformation.IsListBoxSmoothScrollingEnabled ? 1 : 0));
            environmentInfo.Add("Selection fade enabled", new DecimalContextInformation(SystemInformation.IsSelectionFadeEnabled ? 1 : 0));
            environmentInfo.Add("Snap to default button enabled", new DecimalContextInformation(SystemInformation.IsSnapToDefaultEnabled ? 1 : 0));
            environmentInfo.Add("Show sounds enabled", new DecimalContextInformation(SystemInformation.ShowSounds ? 1 : 0));

            return environmentInfo;
        }
    }
}
